% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_mcdd.R
\name{dfr_mcdd}
\alias{dfr_mcdd}
\title{Mean Comparison Distance method}
\usage{
dfr_mcdd(target_feat, alpha = 0.05, window_size = 100)
}
\arguments{
\item{target_feat}{Feature to be monitored}

\item{alpha}{Probability theshold for all test statistics}

\item{window_size}{Size of the sliding window}
}
\value{
\code{dfr_mcdd} object
}
\description{
Mean Comparison statistical method for concept drift detection.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_mcdd(target_feat='depart_visibility')

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
