/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;

public class Sequence {
    private ArrayList<Residue> seq = new ArrayList();
    private String name;

    public Sequence() {
        this("");
    }

    public Sequence(String string) {
        this(string, "Unnamed sequence");
    }

    public Sequence(String string, String string2) {
        this.seq.ensureCapacity(string.length());
        for (int i = 0; i < string.length(); ++i) {
            Residue residue = new Residue(string.charAt(i));
            this.seq.add(residue);
        }
        this.name = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String drawStuff(String string, String string2, String string3, String string4) {
        String string5 = "";
        try {
            File file = new File(string3);
            Sequence sequence = new Sequence(string, string2);
            if (string4.equalsIgnoreCase("WENXIANG")) {
                sequence.wenxiangPNG(file);
            } else if (string4.equalsIgnoreCase("WHEEL")) {
                sequence.wheelPNG(file);
            } else {
                throw new IllegalArgumentException("`" + string4 + "` is not a valid type of diagram to draw (either `wheel` or `wenxiang`)");
            }
            string5 = "Success";
            return string5;
        }
        catch (Exception exception) {
            string5 = "Exception thrown: " + exception.getMessage();
            return string5;
        }
        finally {
            return string5;
        }
    }

    public Residue residAt(int n) {
        return this.seq.get(n);
    }

    public char charAt(int n) {
        return this.residAt(n).oneLetterCode();
    }

    public String getSeq() {
        return this.toString();
    }

    public int length() {
        return this.seq.size();
    }

    public String getName() {
        return this.name;
    }

    public void wheelPNG(File file) {
        StaticVis.outputWheel(this, file);
    }

    public void wenxiangPNG(File file) {
        StaticVis.outputWenxiang(this, file);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Residue residue : this.seq) {
            stringBuilder.append(residue.oneLetterCode());
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
    }
}

