% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_feature_list.R
\name{select_feature}
\alias{select_feature}
\title{Interactively browse and select features}
\usage{
select_feature(base.url = NULL, get = FALSE)
}
\arguments{
\item{base.url}{WFS url, for example "https://kartta.hsy.fi/geoserver/wfs"}

\item{get}{Should the selected feature be downloaded? Default is \code{FALSE}}
}
\value{
feature Title (character) or feature object (sf), if \code{get} parameter is TRUE
}
\description{
Use an interactive menu to select and download a feature 
for use in other functions
}
\examples{
\dontrun{
selection <- select_feature(base.url = "https://kartta.hsy.fi/geoserver/wfs")
feature <- get_feature(base.url = "https://kartta.hsy.fi/geoserver/wfs", type_name = selected)
ggplot(feature) +
  geom_sf()
}

}
\seealso{
\code{\link{get_feature}}, \code{\link{get_feature_list}}
}
\author{
Pyry Kantanen <pyry.kantanen@gmail.com>
}
