% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traffic.R
\name{traffic}
\alias{traffic}
\title{HERE Traffic API: Flow and Incidents}
\usage{
traffic(aoi, product = "flow", from_dt = NULL, to_dt = NULL,
  local_time = FALSE, url_only = FALSE)
}
\arguments{
\item{aoi}{\code{sf} object, Areas of Interest (POIs) of geometry type \code{POLYGON}.}

\item{product}{character, traffic product of the 'Traffic API'. Supported products: \code{"flow"} and \code{"incidents"}.}

\item{from_dt}{datetime, timestamp of type \code{POSIXct}, \code{POSIXt} for the earliest traffic information.}

\item{to_dt}{datetime, timestamp of type \code{POSIXct}, \code{POSIXt} for the latest traffic information.}

\item{local_time}{boolean, should time values in the response for traffic incidents be in the local time of the incident or in UTC (\code{default = FALSE})?}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested traffic information.
}
\description{
Traffic flow and incident information based on the 'Traffic' API.
The traffic flow data contains speed (\code{"SP"}) and congestion (jam factor: \code{"JF"}) information.
Traffic incidents contain information about location, time, duration, severity, description and other details.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

# Traffic flow for the last hour
flow <- traffic(
  aoi = aoi[aoi$code == "LI", ],
  product = "flow",
  from_dt = Sys.time() - 60*60*1,
  to_dt = Sys.time(),
  url_only = TRUE
)

# All traffic incidents from 2018 till end of 2019
incidents <- traffic(
  aoi = aoi[aoi$code == "LI", ],
  product = "incidents",
  from_dt = as.POSIXct("2018-01-01 00:00:00"),
  to_dt = as.POSIXct("2019-12-31 23:59:59"),
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/api-explorer/rest/traffic}{HERE Traffic API}
}
