% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_matrix.R
\name{route_matrix}
\alias{route_matrix}
\title{HERE Matrix Routing API: Calculate Matrix}
\usage{
route_matrix(
  origin,
  destination = origin,
  datetime = Sys.time(),
  routing_mode = "fast",
  transport_mode = "car",
  traffic = TRUE,
  url_only = FALSE
)
}
\arguments{
\item{origin}{\code{sf} object, the origin locations (M) of geometry type \code{POINT}.}

\item{destination}{\code{sf} object, the destination locations (N) of geometry type \code{POINT}.}

\item{datetime}{\code{POSIXct} object, datetime for the departure.}

\item{routing_mode}{character, set the routing type: \code{"fast"} or \code{"short"} (\code{default = "fast"}).}

\item{transport_mode}{character, set the transport mode: \code{"car"}, \code{"truck"}, \code{"pedestrian"}, \code{"bicycle"}, \code{"scooter"}, \code{"taxi"}, \code{"bus"} or \code{"privateBus"} (\code{default = "car"}).}

\item{traffic}{boolean, use real-time traffic or prediction in routing (\code{default = TRUE})? If no traffic is selected, the \code{datetime} is set to \code{"any"} and the request is processed independently from time.}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
A \code{data.frame}, which is an edge list containing the requested M:N route combinations.
}
\description{
Calculates a matrix of M:N, M:1 or 1:N route summaries between given points of interest (POIs) using the HERE 'Matrix Routing' API.
Various transport modes and traffic information at a provided timestamp are supported.
The requested matrix is split into (sub-)matrices of dimension 15x100 to use the
maximum matrix size per request and thereby minimize the number of overall needed requests.
The result is one route summary matrix, that fits the order of the provided POIs: \code{orig_id}, \code{dest_id}.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Create routes summaries between all POIs
mat <- route_matrix(
  origin = poi,
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/matrix-routing-api/dev_guide/index.html}{HERE Matrix Routing API}
}
