% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{quant}
\alias{quant}
\title{Estimates the quantiles at a vector of probability values}
\usage{
quant(this, p)
}
\arguments{
\item{this}{A hermite_estimator object.}

\item{p}{A numeric vector. A vector of probability values.}
}
\value{
A numeric vector. The vector of quantile values associated with the
probabilities p.
}
\description{
Estimates the quantiles at a vector of probability values
}
\examples{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, rnorm(30))
quant_est <- quant(hermite_est, c(0.25, 0.5, 0.75))
}
