% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.data2d.R
\name{generate.data2d}
\alias{generate.data2d}
\alias{generate_data2d}
\alias{generateData2d}
\alias{GenerateData2d}
\title{Generate 2d data}
\usage{
generate.data2d()

generate_data2d()

generateData2d()

GenerateData2d()
}
\value{
A list with components \code{x}, \code{mu2d}, and
  \code{data2d}.  \code{x} is a list of sequences with
  length 60 and 80.  \code{mu2d} and \code{data2d} are
  matrices of size 60 by 80.
}
\description{
Generate two-dimensional data related to the f1 function
of Lu et al. (2012) (code from author).  Define \code{n =
c(60, 80)}.  Then \code{x[[i]] = (1:n[i])/n[i] -
1/2/n[i]}.  These are the observed data locations. For
\code{i} and \code{j} spanning the full length of each
element of \code{x}, \code{mu2d[i, j] = sin(2 * pi *
(x[[1]][i] - .5) ^ 3) * cos(4 * pi * x[[2]][j])}.  Lastly,
\code{data2d = mu2d + rnorm(prod(n))}.
}
\examples{
dat = generate.data2d()
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599.  <doi:10.1111/rssb.12007>
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
