% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglambda2gcv.R
\name{loglambda2gcv}
\alias{loglambda2gcv}
\title{Determine GCV statistic}
\usage{
loglambda2gcv(loglambda, obj, loggcv = FALSE)
}
\arguments{
\item{loglambda}{A vector of penalty values (assumed to
be on a natural logarithmic scale) for computing the GCV.}

\item{obj}{A \code{prepared_*} object from a
\code{\link{prepare}} function.}

\item{loggcv}{A logical value indicating whether the log of the
GCV statistic should be returned.
The default is \code{FALSE}.}
}
\value{
The scalar GCV statistic
}
\description{
\code{loglambda2gcv} uses a vector of penalty values
to evaluate the GCV statistic for a
\code{prepared_response} object.
}
\details{
Though this function can be used by the user, it is
basically an internal function used to find the
value of \code{loglambda} minimizing the GCV statistic.
}
\examples{
n1 = 10
b1 = bspline(nbasis = 10)
x1 = seq(0, 1, len = n1)
n2 = 20
x2 = seq(0, 1, len = n2)
b2 = bspline(nbasis = 12)
# construct "true" data
mu = matrix(0, nrow = n1, ncol = n2)
for(i in seq_len(n1)) {
   for(j in seq_len(n2)) {
      mu[i, j] =  sin(2*pi*(x1[i]-.5)^3)*cos(4*pi*x2[j])
   }
}
image(mu)
# construct noisy data
data = mu + rnorm(n1 * n2)
x = list(x1, x2)
splines = list(b1, b2)
obj = prepare(data, x, splines)
loglambda2gcv(c(0, 0), obj)
}
\seealso{
\code{\link{prepare}}
}
