% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.array.R
\name{prepare.array}
\alias{prepare.array}
\title{Prepare data array for sandwich smooth}
\usage{
\method{prepare}{array}(data, x, splines, m = 2, sparse = TRUE, ...)
}
\arguments{
\item{data}{A data array}

\item{x}{A list of univariate, equidistant
sequences.  These should correspond to where the data
are observed.  Equidistant spacing between 0 and 1 is
assumed if not supplied.  See Details.}

\item{splines}{A list of spline-related objects, e.g.,
produced by \code{\link{bspline}}.  Splines are
automatically created if not supplied.  See Details.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{...}{Not currently implemented.}
}
\value{
A \code{prepared_array} object.
}
\description{
\code{prepare.array} prepares a data matrix for the
sandwich smooth.  The dimensionality of \code{data} and
the length of \code{x} must match.  Specifically,
\code{length(dim(data))} must equal
\code{length(x)}.     The dimensionality of
\code{data} and  the length of \code{splines} must match.
Specifically, \code{length(dim(data))} must equal
\code{length(splines)}.
}
\details{
For a typical sandwich smooth, for data with \eqn{d}
dimensions, \code{Y[i1, i2, ...,id]} is assumed to be
observed at position \code{x[[1]][i1]},
\code{x[[2]][i2]}, ..., \code{x[[d]][id]}.
Consequently, \code{dim(data)[i]} should equal
\code{length(x[[i]])} for all \code{i} in
\code{seq_len(d)}.

If \code{x} is not supplied, then
\code{\link{default.evalargs}} is used to create it
automatically.

If \code{splines} is not supplied, then a B-spline basis
is automatically created for each dimension using
\code{\link{default.splines}}.
}
\examples{
# generate and prepare 3d data
set.seed(9)
dat = generate.data3d()
obj = prepare(dat$data3d, x = dat$x)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\seealso{
\code{\link{bspline}},
  \code{\link{default.evalargs}},
  \code{\link{default.splines}}
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
