% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.matrix.R
\name{prepare.matrix}
\alias{prepare.matrix}
\title{Prepare data matrix for sandwich smooth}
\usage{
\method{prepare}{matrix}(
  data,
  x,
  splines,
  m = 2,
  sparse = TRUE,
  spdiffpen = TRUE,
  digits = 1,
  sts = FALSE,
  ...
)
}
\arguments{
\item{data}{A data matrix.}

\item{x}{A list of values at which to evaluate the basis
functions.  See Examples and Details.}

\item{splines}{A list of spline objects
(\code{hero_bspline} and \code{hero_radspline}).  See
Examples and Details.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{spdiffpen}{A logical value indicating whether
\code{\link{spdiffpen}} should be used to compute the
difference penalty.  The default is \code{FALSE}.}

\item{digits}{The number of digits to use when applying
\code{\link[base]{round}} to the distances.}

\item{sts}{A logical value indicating whether \code{data}
is a spatial time series, in which each row of
\code{data} corresponds to a distinct spatial location
and each column corresponds to a distinct time.}

\item{...}{Not currently implemented.}
}
\value{
A \code{prepared_matrix} object.
}
\description{
\code{prepare.matrix} prepares a data matrix for the
sandwich smooth.  The dimensionality of \code{data} and
the length of \code{x} must match.  Specifically,
\code{length(dim(data))} must equal
\code{length(x)}.     The dimensionality of
\code{data} and the length of \code{splines} must match.
Specifically, \code{length(dim(data))} must equal
\code{length(splines)}.
}
\details{
For a typical sandwich smooth (\code{sts = FALSE}),
for two-dimensional data, \code{data[i, j]} is assumed
to be observed at position \code{x[[1]][i]},
\code{x[[2]][j]}.  If the data are a spatial time series,
then the first dimension is assumed to refer to space,
and the second dimension to time.  In that case,
\code{data[i, j]} is assumed
to be observed at location \code{x[[1]][i, ]} and time
\code{x[[2]][j]}.

If \code{sts = TRUE}, then \code{x[[1]]} should be a
matrix of spatial coordinates, with each row
corresponding to a location, and \code{x[[2]]} should
be a vector with the observation times.

If \code{x} is not supplied, then
\code{\link{default.evalargs}} is used to create it
automatically.  This is only valid when
\code{sts = FALSE}.

If \code{splines} is not supplied, then a B-spline basis
is automatically created for each dimension using
\code{\link{default.splines}}.  This is only valid when
\code{sts = FALSE}.
}
\examples{
# prepare Lu et al. (2012) noisy f1 data
data(ludata)
obj = prepare(lunoisyf1, x = list(x, z))
h = hero(obj)

# precompute some stuff
splines = default.splines(list(x, z))
l = assemble(splines, x = list(x, z))
obj2 = prepare(lunoisyf1, x = list(x, z),
               splines = splines, assembled = l)
h2 = hero(obj2)
all.equal(h, h2)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\seealso{
\code{\link{bspline}}, \code{\link{radspline}},
\code{\link{diffpen}}, \code{\link{spdiffpen}},
  \code{\link{default.evalargs}},
  \code{\link{default.splines}}
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
