% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-data.R
\name{create_trans_dt}
\alias{create_trans_dt}
\title{Create a data table of health state transitions}
\usage{
create_trans_dt(trans_mat)
}
\arguments{
\item{trans_mat}{A transition matrix in the format from the \link[mstate]{mstate} package. 
See \link{IndivCtstmTrans}.}
}
\value{
Returns a \code{\link{data.table}} in tidy format with three columns
\describe{
\item{transition_id}{Health state transition ID.}
\item{from}{The starting health state.}
\item{to}{The health state that will be transitions to.}
}
}
\description{
Create a data table of health state transitions from a transition matrix describing 
the states and transitions in a multi-state model suitable for use with \link{hesim_data}.
}
\examples{
tmat <- rbind(c(NA, 1, 2),
              c(NA, NA, 3),
              c(NA, NA, NA))
create_trans_dt(tmat)
}
