% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-data.R
\name{hesim_data}
\alias{hesim_data}
\title{Data for health-economic simulation modeling}
\usage{
hesim_data(strategies, patients, lines = NULL, states = NULL,
  transitions = NULL, times = NULL)
}
\arguments{
\item{strategies}{A table of treatment strategies. 
Must contain the column \code{strategy_id} denoting a unique strategy. Other columns are variables
 describing the characteristics of a treatment strategy.}

\item{patients}{A table of patient observations. 
Must contain the column \code{patient_id} denoting a unique patient. The 
number of rows should be equal to the number of patients in the model.
Other columns are variables describing the characteristics of a patient.}

\item{lines}{A table of treatment lines used for each treatment strategy. Must contain the columns
\code{strategy_id}, denoting a treatment strategy, and \code{line}, denoting a treatment line. Other 
columns are variables describing the characteristics of a treatment line for a given treatment
strategy. A column denoting the treatment used for a given strategy and line would often
be specified. Not currently supported.}

\item{states}{A table of health states. Must contain the column
\code{state_id}, which denotes a unique health state. The number of rows should
be equal to the number of health states in the model. Other columns can describe the
characteristics of a health state.}

\item{transitions}{A table of health state transitions. Must contain the column
\code{transition_id}, which denotes a unique transition; \code{from}, which denotes
the starting health state; and \code{to} which denotes the state that will be
transitioned to.}

\item{times}{A table of time intervals. Must contain the column \code{time_start}, 
which denotes the starting time of times intervals defined between \code{time_start}
 and \code{time_stop}. \code{hesim_data()} automatically creates the columns
 \code{time_stop} and \code{time_id} (a vector of integers sorted by \code{time_start}).
 Time intervals are closed on the left and open on the right and the final time
  interval is defined from \code{time_start} to infinity.}
}
\value{
Returns an object of class "hesim_data", which is a list of data tables for
health economic simulation modeling.
}
\description{
A list of tables required for health-economic simulation modeling.
Each table must either be a \code{\link{data.frame}} or \code{\link{data.table}}. All ID variables within 
each table must be numeric vectors of integers.
}
\examples{
strategies <- data.frame(strategy_id = c(1, 2))
patients <- data.frame(patient_id = seq(1, 3), age = c(65, 50, 75),
                          gender = c("Female", "Female", "Male"))
states <- data.frame(state_id =  seq(1, 3),
                        state_var = c(2, 1, 9))
times <- data.frame(time_id = c(1, 2, 3),
                    time_start = c(0, 4, 9),
                    time_stop = c(4, 9, Inf))
hesim_dat <- hesim_data(strategies = strategies,
                         patients = patients,
                         states = states,
                         times = times)
}
\seealso{
\code{\link{expand.hesim_data}}
}
