% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_surv.R
\name{params_surv}
\alias{params_surv}
\alias{print.params_surv}
\title{Parameters of a survival model}
\usage{
params_surv(coefs, dist, aux = NULL)
}
\arguments{
\item{coefs}{A list of length equal to the number of parameters in the
survival distribution. Each element of the list is a matrix of samples
of the regression coefficients under sampling uncertainty used to predict
a given parameter. All parameters are expressed on the real line (e.g.,
after log transformation if they are defined as positive). Each element
of the list may also be an object coercible to a matrix such as a
\code{data.frame} or \code{data.table}.}

\item{dist}{Character vector denoting the parametric distribution. See "Details".}

\item{aux}{Auxiliary arguments used with splines, fractional polynomial,
or piecewise exponential models. See "Details".}
}
\value{
An object of class \code{params_surv}, which is a list containing \code{coefs},
\code{dist}, and \code{n_samples}. \code{n_samples} is equal to the
number of rows in each element of \code{coefs}, which must be the same. The \code{coefs}
element is always converted into a list of matrices. The list may also contain
\code{aux} if a spline, fractional polynomial, or piecewise exponential model is
used.
}
\description{
Create a list containing the parameters of a single fitted parametric or
flexible parametric survival model.
}
\details{
Survival is modeled as a function of \eqn{L} parameters \eqn{\alpha_l}.
Letting \eqn{F(t)} be the cumulative distribution function, survival at time \eqn{t}
is given by
\deqn{1 - F(t | \alpha_1(x_{1}), \ldots, \alpha_L(x_{L})).}
The parameters are modeled as a function of covariates, \eqn{x_l}, with an
inverse transformation function \eqn{g^{-1}()},
\deqn{\alpha_l =  g^{-1}(x_{l}^T \beta_l).}
\eqn{g^{-1}()} is typically \eqn{exp()} if a parameter is strictly positive
and the identity function if the parameter space is unrestricted.

The types of distributions that can be specified are:
\describe{
\item{\code{exponential} or \code{exp}}{ Exponential distribution. \code{coef}
must contain the \code{rate} parameter on the log scale and the same parameterization as in
\code{\link[stats:Exponential]{stats::Exponential}}.}

\item{\code{weibull} or \code{weibull.quiet}}{ Weibull distribution. The first
element of \code{coef} is the \code{shape} parameter (on the log scale) and the second
element is the \code{scale} parameter (also on the log scale). The parameterization is
that same as in \code{\link[stats:Weibull]{stats::Weibull}}.}

\item{\code{weibullPH}}{ Weibull distribution with a proportional hazards
parameterization. The first element of \code{coef} is the \code{shape} parameter
(on the log scale) and the second element is the \code{scale} parameter
(also on the log scale). The parameterization is
that same as in \code{\link[flexsurv:WeibullPH]{flexsurv::WeibullPH}}.}

\item{\code{gamma}}{ Gamma distribution. The first
element of \code{coef} is the \code{shape} parameter (on the log scale) and the second
element is the \code{rate} parameter (also on the log scale). The parameterization is
that same as in \code{\link[stats:GammaDist]{stats::GammaDist}}.}

\item{\code{lnorm}}{ Lognormal distribution. The first
element of \code{coef} is the \code{meanlog} parameter (i.e., the mean of survival on
the log scale) and the second element is the \code{sdlog} parameter (i.e.,
the standard deviation of survival on the log scale). The parameterization is
that same as in \code{\link[stats:Lognormal]{stats::Lognormal}}. The coefficients predicting the \code{meanlog}
parameter are untransformed whereas the coefficients predicting the \code{sdlog}
parameter are defined on the log scale.}

\item{\code{gompertz}}{ Gompertz distribution. The first
element of \code{coef} is the \code{shape} parameter and the second
element is the \code{rate} parameter (on the log scale). The parameterization is
that same as in \code{\link[flexsurv:Gompertz]{flexsurv::Gompertz}}.}

\item{\code{llogis}}{ Log-logistic distribution. The first
element of \code{coef} is the \code{shape} parameter (on the log scale) and the second
element is the \code{scale} parameter (also on the log scale). The parameterization is
that same as in \code{\link[flexsurv:Llogis]{flexsurv::Llogis}}.}

\item{\code{gengamma}}{ Generalized gamma distribution. The first
element of \code{coef} is the location parameter \code{mu}, the second
element is the scale parameter \code{sigma} (on the log scale), and the
third element is the shape parameter \code{Q}. The parameterization is
that same as in \code{\link[flexsurv:GenGamma]{flexsurv::GenGamma}}.}

\item{\code{survspline}}{ Survival splines. Each element of \code{coef} is a parameter of the
spline model (i.e. \code{gamma_0}, \code{gamma_1}, \eqn{\ldots}) with length equal
to the number of knots (including the boundary knots). See below for details on the
auxiliary arguments. The parameterization is that same as in \code{\link[flexsurv:Survspline]{flexsurv::Survspline}}.}

\item{\code{fracpoly}}{ Fractional polynomials. Each element of \code{coef} is a parameter of the
fractional polynomial model (i.e. \code{gamma_0}, \code{gamma_1}, \eqn{\ldots}) with length equal
to the number of powers plus 1. See below for details on the auxiliary arguments
(i.e., \code{powers}).}

\item{\code{pwexp}}{ Piecewise exponential distribution. Each element of \code{coef} is
rate parameter for a distinct time interval. The times at which the rates
change should be specified with the auxiliary argument \code{time} (see below
for more details)}.

\item{\code{fixed}}{ A fixed survival time. Can be used for "non-random" number
generation. \code{coef} should contain a single parameter, \code{est}, of the fixed
survival times.}
}

Auxiliary arguments for spline models should be specified as a list containing the elements:
\describe{
\item{\code{knots}}{A numeric vector of knots.}
\item{\code{scale}}{The survival outcome to be modeled
as a spline function. Options are \code{"log_cumhazard"} for the log cumulative hazard;
\code{"log_hazard"} for the log hazard rate; \code{"log_cumodds"} for the log cumulative odds;
and \code{"inv_normal"} for the inverse normal distribution function.}
\item{\code{timescale}}{If \code{"log"} (the default), then survival is modeled as a spline function
of log time; if \code{"identity"}, then it is modeled as a spline function of time.}
}

Auxiliary arguments for fractional polynomial models should be specified as a list containing the elements:
\describe{
\item{\code{powers}}{ A vector of the powers of the fractional polynomial with each element
chosen from the following set: -2. -1, -0.5, 0, 0.5, 1, 2, 3.}
}

Auxiliary arguments for piecewise exponential models should be specified as
a list containing the element:
\describe{
\item{\code{time}}{ A vector equal to the number of rate parameters giving the
times at which the rate changes.}
}

Furthermore, when splines (with \code{scale = "log_hazard"}) or fractional
polynomials are used, numerical methods must be used to compute the cumulative
hazard and for random number generation. The following additional auxiliary arguments
can therefore be specified:
\describe{
\item{\code{cumhaz_method}}{Numerical method used to compute cumulative hazard
(i.e., to integrate the hazard function). Always used for fractional polynomials
but only used for splines if \code{scale = "log_hazard"}.
Options are \code{"quad"} for adaptive quadrature and \code{"riemann"} for Riemann sum.}
\item{\code{random_method}}{Method used to randomly draw from
an arbitrary survival function. Options are \code{"invcdf"} for the inverse CDF and
\code{"discrete"} for a discrete time approximation that randomly samples
events from a Bernoulli distribution at discrete times.}
\item{\code{step}}{Step size for computation of cumulative hazard with
numerical integration. Only required when using \code{"riemann"} to compute the
cumulative hazard or using \code{"discrete"} for random number generation.}
}
}
\examples{
n <- 10
params <- params_surv(
  coefs = list(
    shape = data.frame(
      intercept = rnorm(n, .5, .23)
    ),
    scale = data.frame(
      intercept = rnorm(n, 12.39, 1.49),
      age = rnorm(n, -.09, .023)
   )
  ),
  dist = "weibull"
)
summary(params)
params
}
