% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_hetGP.R
\name{LOO_preds}
\alias{LOO_preds}
\title{Leave one out predictions}
\usage{
LOO_preds(model, ids = NULL)
}
\arguments{
\item{model}{\code{homGP} or \code{hetGP} model, TP version is not considered at this point}

\item{ids}{vector of indices of the unique design point considered (default to all)}
}
\value{
list with mean and variance predictions at x_i assuming this point has not been evaluated
}
\description{
Provide leave one out predictions, e.g., for model testing
}
\examples{
set.seed(32)
## motorcycle data
library(MASS)
X <- matrix(mcycle$times, ncol = 1)
Z <- mcycle$accel
nvar <- 1
plot(X, Z, ylim = c(-160, 90), ylab = 'acceleration', xlab = "time")

## Model fitting
model <- mleHomGP(X = X, Z = Z, lower = rep(0.1, nvar), upper = rep(50, nvar),
                  covtype = "Matern5_2", known = list(beta0 = 0))
LOO_p <- LOO_preds(model)
 
# model minus observation(s) at x_i
d_mot <- find_reps(X, Z)

LOO_ref <- matrix(NA, nrow(d_mot$X0), 2)
for(i in 1:nrow(d_mot$X0)){
 model_i <- mleHomGP(X = list(X0 = d_mot$X0[-i,, drop = FALSE], Z0 = d_mot$Z0[-i],
                     mult = d_mot$mult[-i]), Z = unlist(d_mot$Zlist[-i]),
                     lower = rep(0.1, nvar), upper = rep(50, nvar), covtype = "Matern5_2",
                     known = list(theta = model$theta, k_theta_g = model$k_theta_g, g = model$g,
                                  Delta = model$Delta[-i], beta0 = 0))
 model_i$nu_hat <- model$nu_hat
 p_i <- predict(model_i, d_mot$X0[i,,drop = FALSE])
 LOO_ref[i,] <- c(p_i$mean, p_i$sd2)
}

# Compare results

range(LOO_ref[,1] - LOO_p$mean)
range(LOO_ref[,2] - LOO_p$sd2)
}
\references{
O. Dubrule (1983), Cross validation of Kriging in a unique neighborhood, Mathematical Geology 15, 687--699. \cr \cr

F. Bachoc (2013), Cross Validation and Maximum Likelihood estimations of hyper-parameters of Gaussian processes 
with model misspecification, Computational Statistics & Data Analysis, 55--69.
}
