% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterocop.R
\name{omega_estim}
\alias{omega_estim}
\title{omega_estim}
\usage{
omega_estim(data, Type, lambda, n)
}
\arguments{
\item{data}{a dataset of size nxd or a correlation matrix R of size dxd}

\item{Type}{a vector containing the type of the variables, "C" for continuous and "D" for discrete (in the case a data set is entered as the first parameter)}

\item{lambda}{a grid of penalization parameters to be evaluated}

\item{n}{the sample size used (in the case of a correlation matrix entered as the first parameter)}
}
\value{
a list containing the correlation matrix, the optimal precision matrix, the optimal lambda, the minimal HBIC
}
\description{
This function enables the user estimate the precision matrix of the latent variables via gLasso inversion
}
\examples{
M <- diag_block_matrix(c(3,4,5),c(0.7,0.8,0.2))
data <- CopulaSim(20,M,c(rep("qnorm(0,1)",6),rep("qexp(0.5)",4),
rep("qbinom(4,0.8)",2)),random=FALSE)[[1]]
\donttest{P <- omega_estim(data,c(rep("C",10),rep("D",2)),seq(0.01,1,0.05))}

}
