% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-utils.R
\name{discretize_numbers}
\alias{discretize_numbers}
\title{Discretize continuous numbers}
\usage{
discretize_numbers(x, min_size = 1, ...)
}
\arguments{
\item{x}{vector of numbers.}

\item{min_size}{minimum size of bins at the edges. Any bins smaller than this size are combined.}

\item{...}{Arguments passed on to \code{get_breaks}
\describe{
  \item{N}{step size. The eventual intervals will be multiples of the divisors of \code{N} or
multiples of \code{N} when \code{multiples_only} is \code{TRUE}. Defaults to 10.}
  \item{max_breaks}{maximum amount of breaks, defaults to 10.}
  \item{int_only}{whether only integer divisors of \code{N} may be used as breaks, defaults to \code{TRUE}.}
  \item{multiples_only}{whether only multiples of \code{N} can be used as breaks, defaults to \code{FALSE}.}
}}
}
\value{
A factor with the same length as \code{x}, with labels indicating bins.
}
\description{
Discretize continuous numbers
}
\details{
The function \code{get_breaks} is called to create the boundaries between groups.
It is called on default with \code{limits = range(x)} and with \code{include_bounds = FALSE}.
This behaviour may be overridden with the \code{...} argument, although it is advised not to do so to avoid empty groups.

\code{NA} values are preserved in the result.
}
\examples{
ages = round(rnorm(1000,50,10)); ages[1] = NA
discretize_numbers(ages)
}
