% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstat2dos.R
\name{fstat2dos}
\alias{fstat2dos}
\title{Converts a hierfstat genetic data frame to dosage data}
\usage{
fstat2dos(dat,diploid=TRUE)
}
\arguments{
\item{dat}{data frame with genetic data without the first column (population identifier)}

\item{diploid}{whether the data set is from a diploid organism}
}
\value{
a matrix with \eqn{\sum_l n_l^a} columns (where \eqn{n_l^a} is the number of alleles 
at locus l), as many rows as individuals, and containing the number of copies (dosage) of the 
corresponding allele
}
\description{
Converts a hierfstat genetic data frame to dosage. For each allele at each locus, 
allelic dosage (number of copies of the allele) is reported. The column name is the allele 
identifier
}
\examples{
\dontrun{
dat<-sim.genot(nbal=5,nbloc=10)
dos<-fstat2dos(dat[,-1])
dim(dos) 
wc(dat)
fst.dosage(dos,pop=dat[,1])

} 
}
