% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts-ts-xts.R
\name{hc_add_series_xts}
\alias{hc_add_serie_xts}
\alias{hc_add_series_xts}
\title{Shorcut for create highstock chart from \code{xts} object}
\usage{
hc_add_series_xts(hc, x, ...)

hc_add_serie_xts(hc, x, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{x}{A \code{xts} object from the \pkg{quantmod} package.}

\item{...}{Aditional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function helps to create highstock charts from \code{xts} objects
obtaining by \code{getSymbols} function from the  \pkg{quantmod}.
}
\examples{

library("quantmod")

usdjpy <- getSymbols("USD/JPY", src="oanda", auto.assign = FALSE)
eurkpw <- getSymbols("EUR/KPW", src="oanda", auto.assign = FALSE)

highchart(type = "stock") \%>\% 
  hc_add_series_xts(usdjpy, id = "usdjpy") \%>\% 
  hc_add_series_xts(eurkpw, id = "eurkpw")

}

