% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{rmTradeOutliersUsingQuotes}
\alias{rmTradeOutliersUsingQuotes}
\title{Delete transactions with unlikely transaction prices}
\usage{
rmTradeOutliersUsingQuotes(
  tData,
  qData,
  lagQuotes = 0,
  nSpreads = 1,
  BFM = FALSE,
  backwardsWindow = 3600,
  forwardsWindow = 0.5,
  plot = FALSE,
  ...
)
}
\arguments{
\item{tData}{a \code{data.table} or \code{xts} object containing the time series data, with at least the column \code{"PRICE"}, containing the transaction price.}

\item{qData}{a \code{data.table} or \code{xts} object containing the time series data with at least the columns \code{"BID"} and \code{"OFR"}, containing the bid and ask prices.}

\item{lagQuotes}{numeric, number of seconds the quotes are registered faster than
the trades (should be round and positive). Default is 0. For older datasets, i.e. before 2010, it may be a good idea to set this to e.g. 2. See Vergote (2005)}

\item{nSpreads}{numeric of length 1 denotes how far above the offer and below bid we allow outliers to be. Trades are filtered out if they are MORE THAN nSpread * spread above (below) the offer (bid)}

\item{BFM}{a logical determining whether to conduct 'Backwards - Forwards matching' of trades and quotes.
The algorithm tries to match trades that fall outside the bid - ask and first tries to match a small window forwards and if this fails, it tries to match backwards in a bigger window.
The small window is a tolerance for inaccuracies in the timestamps of bids and asks. The backwards window allow for matching of late reported trades, i.e. block trades.}

\item{backwardsWindow}{a numeric denoting the length of the backwards window. Default is 3600, corresponding to one hour.}

\item{forwardsWindow}{a numeric denoting the length of the forwards window. Default is 0.5, corresponding to one half second.}

\item{plot}{a logical denoting whether to visualize the forwards, backwards, and unmatched trades in a plot.}

\item{...}{used internally}
}
\value{
\code{xts} or \code{data.table} object depending on input.
}
\description{
Function deletes entries with prices that are above the ask plus the bid-ask spread.
Similar for entries with prices below the bid minus the bid-ask spread.
}
\details{
Note: in order to work correctly, the input data of this function should be
cleaned trade (tData) and quote (qData) data respectively.
In older high frequency datasets the trades frequently lag the quotes. In newer datasets this tends to happen 
only during extreme market activity when exchange networks are at maximum capacity.
}
\references{
Vergote, O. (2005). How to match trades and quotes for NYSE stocks? K.U.Leuven working paper.

Christensen, K., Oomen, R. C. A., Podolskij, M. (2014): Fact or Friction: Jumps at ultra high frequency. \emph{Journal of Financial Economics}, 144, 576-599
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
