% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_convergence.R
\name{hbl_convergence}
\alias{hbl_convergence}
\title{Check convergence diagnostics}
\usage{
hbl_convergence(mcmc)
}
\arguments{
\item{mcmc}{A wide data frame of posterior samples returned by
\code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}} or similar MCMC function.}
}
\value{
A data frame of summarized convergence diagnostics.
\code{max_rhat} is the maximum univariate Gelman/Rubin potential scale
reduction factor over all the parameters of the model,
\code{min_ess_bulk} is the minimum bulk effective sample size over the
parameters, and \code{min_ess_tail} is the minimum tail effective
sample size. \code{max_rhat} should be below 1.01, and the ESS metrics
should both be above 100 times the number of MCMC chains. If
any of these conditions are not true, the MCMC did not converge,
and it is recommended to try running the model for more saved
iterations (and if \code{max_rhat} is high, possibly more warmup
iterations).
}
\description{
Check the convergence diagnostics on a model.
}
\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_pool(
  n_study = 2,
  n_group = 2,
  n_patient = 5,
  n_rep = 3
)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc <- hbl_mcmc_pool(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
hbl_convergence(mcmc)
}
}
\seealso{
Other mcmc: 
\code{\link{hbl_mcmc_hierarchical}()},
\code{\link{hbl_mcmc_independent}()},
\code{\link{hbl_mcmc_pool}()},
\code{\link{hbl_mcmc_sge}()}
}
\concept{mcmc}
