% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simNIDA}
\alias{simNIDA}
\title{Simulate NIDA model responses (entire cube)}
\usage{
simNIDA(alphas, Svec, Gvec, Q_matrix, Test_order, Test_versions)
}
\arguments{
\item{alphas}{An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points}

\item{Svec}{A length K \code{vector} of slipping probability in applying mastered skills}

\item{Gvec}{A length K \code{vector} of guessing probability in applying mastered skills}

\item{Q_matrix}{A J-by-K Q-matrix}

\item{Test_order}{A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.}

\item{Test_versions}{A length N \code{vector} of the test version of each examinee}
}
\value{
An \code{array} of NIDA item responses of examinees across all time points
}
\description{
Simulate a cube of NIDA responses for all persons on items across all time points
}
\examples{
N = length(Test_versions)
J = nrow(Q_matrix)
K = ncol(Q_matrix)
L = nrow(Test_order)
Jt = J/L
Svec <- runif(K,.1,.3)
Gvec <- runif(K,.1,.3)
Test_versions_sim <- sample(1:5,N,replace = L)
tau <- numeric(K)
  for(k in 1:K){
    tau[k] <- runif(1,.2,.6)
  }
  R = matrix(0,K,K)
# Initial alphas
    p_mastery <- c(.5,.5,.4,.4)
    Alphas_0 <- matrix(0,N,K)
    for(i in 1:N){
      for(k in 1:K){
        prereqs <- which(R[k,]==1)
        if(length(prereqs)==0){
          Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
        }
        if(length(prereqs)>0){
          Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
        }
      }
    }
   Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
Y_sim = simNIDA(Alphas,Svec,Gvec,Q_matrix,Test_order,Test_versions_sim)
}
