% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_alphas_HO_sep}
\alias{simulate_alphas_HO_sep}
\title{Generate attribute trajectories under the Higher-Order Hidden Markov DCM}
\usage{
simulate_alphas_HO_sep(lambdas, thetas, alpha0s, Q_examinee, L, Jt)
}
\arguments{
\item{lambdas}{A length 4 \code{vector} of transition model coefficients. First entry is intercept of the logistic transition
model, second entry is the slope of general learning ability, third entry is the slope for number of other mastered skills,
fourth entry is the slope for amount of practice.}

\item{thetas}{A length N \code{vector} of learning abilities of each subject.}

\item{alpha0s}{An N-by-K \code{matrix} of subjects' initial attribute patterns.}

\item{Q_examinee}{A length N \code{list} of Jt*K Q matrices across time for each examinee, items are in the order that they are
administered to the examinee}

\item{L}{An \code{int} of number of time points}

\item{Jt}{An \code{int} of number of items in each block}
}
\value{
An N-by-K-by-L \code{array} of attribute patterns of subjects at each time point.
}
\description{
Based on the initial attribute patterns and learning model parameters, create cube of attribute patterns
of all subjects across time. General learning ability is regarded as a fixed effect and has a slope.
}
\examples{
N = length(Test_versions)
J = nrow(Q_matrix)
K = ncol(Q_matrix)
L = nrow(Test_order)
Jt = J/L
class_0 <- sample(1:2^K, N, replace = L)
Alphas_0 <- matrix(0,N,K)
thetas_true = rnorm(N)
for(i in 1:N){
  Alphas_0[i,] <- inv_bijectionvector(K,(class_0[i]-1))
}
lambdas_true = c(-1, 1.8, .277, .055)
Q_examinee <- Q_list(Q_matrix, Test_order, Test_versions)
Alphas <- simulate_alphas_HO_sep(lambdas_true,thetas_true,Alphas_0,Q_examinee,L,Jt)
}
