% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_hmcdm}
\alias{sim_hmcdm}
\title{Simulate responses from the specified model (entire cube)}
\usage{
sim_hmcdm(
  model,
  alphas,
  Q_matrix,
  Design_array,
  itempars = NULL,
  r_stars = NULL,
  pi_stars = NULL,
  Svec = NULL,
  Gvec = NULL
)
}
\arguments{
\item{model}{The cognitive diagnostic model under which the item responses are generated}

\item{alphas}{An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points}

\item{Q_matrix}{A J-by-K of Q-matrix}

\item{Design_array}{A N-by-J-by-L array indicating whether item j is administered to examinee i at l time point.}

\item{itempars}{A J-by-2 \code{mat} of item parameters (slipping: 1st col, guessing: 2nd col).}

\item{r_stars}{A J-by-K \code{mat} of item penalty parameters for missing skills.}

\item{pi_stars}{A length J \code{vector} of item correct response probability with all requisite skills.}

\item{Svec}{A length K \code{vector} of slipping probability in applying mastered skills}

\item{Gvec}{A length K \code{vector} of guessing probability in applying mastered skills}
}
\value{
An \code{array} of item responses from the specified model of examinees across all time points.
}
\description{
Simulate a cube of responses from the specified model for all persons on items across all time points.
Currently available models are \code{DINA}, \code{rRUM}, and \code{NIDA}.
}
\examples{
\donttest{
## DINA ##
N = nrow(Design_array)
J = nrow(Q_matrix)
thetas_true = rnorm(N, 0, 1.8)
lambdas_true <- c(-2, .4, .055)
Alphas <- sim_alphas(model="HO_joint", 
                    lambdas=lambdas_true, 
                    thetas=thetas_true, 
                    Q_matrix=Q_matrix, 
                    Design_array=Design_array)
itempars_true <- matrix(runif(J*2,.1,.2), ncol=2)

Y_sim <- sim_hmcdm(model="DINA",Alphas,Q_matrix,Design_array,
                   itempars=itempars_true)
                   
## rRUM ##
J = nrow(Q_matrix)
K = ncol(Q_matrix)
Smats <- matrix(runif(J*K,.1,.3),c(J,K))
Gmats <- matrix(runif(J*K,.1,.3),c(J,K))
r_stars <- Gmats / (1-Smats)
pi_stars <- apply((1-Smats)^Q_matrix, 1, prod)

Y_sim <- sim_hmcdm(model="rRUM",Alphas,Q_matrix,Design_array,
                   r_stars=r_stars,pi_stars=pi_stars)

## NIDA ##
K = ncol(Q_matrix)
Svec <- runif(K,.1,.3)
Gvec <- runif(K,.1,.3)

Y_sim <- sim_hmcdm(model="NIDA",Alphas,Q_matrix,Design_array,
                   Svec=Svec,Gvec=Gvec)
}
}
