% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SIRSample}
\alias{SIRSample}
\title{Sample SIR data}
\format{
A list of two data frames. The first has 30 rows and 6 variables, the second
60 rows and 6 variables. The structure is the same in both cases:
\describe{
  \item{aSI}{Infection: transition rate from S to I}
  \item{aIR}{Recovery: transition rate from I to R}
  \item{aSR}{Immunisation: transition rate from S to R}
  \item{nS}{Final number of S}
  \item{nI}{Final number of I}
  \item{nR}{Final number of R}
}
}
\usage{
SIRSample
}
\description{
A small dataset containing points generated from a simple deterministic SIR model.
The model contains three input parameters, and generates three output
parameters. The initial populations are 950 susceptible (S), 50 infected (I),
and 0 recovered (R). The final values are taken at time t=10.
}
\details{
The model operates using simple differential equations, where

S' = aSR*R - aSI*S*R/(S+I+R)

I' = aSI*S*R/(S+I+R) - aIR*I

R' = aIR*I - aSR*R.
}
\keyword{datasets}
