% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setmHMM.R
\name{set_mhmm}
\alias{set_mhmm}
\title{\code{S3} Class for Hidden Markov Models with multivariate response.}
\usage{
set_mhmm(Obs, bT = NULL, nStates = NULL, nu = rep(1/nStates,
  nStates), A = matrix(1/nStates, nStates, nStates), corr = NULL,
  params = NULL, distr = NULL)
}
\arguments{
\item{Obs}{a n x p matrix containing the data.}

\item{bT}{the vector of the beginning times for the statistical units.}

\item{nStates}{an integer representing the number of state of the Hidden Markov Model.}

\item{nu}{a vector of the initial probabilities of the Hidden Markov Model.}

\item{A}{the transition matrix of the Hidden Markov Model.}

\item{corr}{an array containing a number of matrix equal to the number of states for the gaussian copula distribution}

\item{params}{a list containing the state-dependent parameters of the Hidden Markov Model. Each element of the list corresponds to a component of the response vector. Each element of the list is a n x d matrix, where n is the number of states of the HMM while d is the number of parameters of the specified distribution.}

\item{distr}{a vector containing the name of the distribution for each component, "gaussian" for the normal distribution, "gamma" for the gamma distribution, "exp" for the exponential distribution}
}
\value{
The function returns an object of \code{S3} class \code{mhmm}, containing the initialization and the data of your HMM
}
\description{
This function creates an object of \code{S3} class \code{mhmm},
 which contains the elements of a Hidden Markov Model with
 multivariate response whose components can be correlated through a
 gaussian copula.
}
\examples{
data(copulahmmdata)
Obs <- copulahmmdata
n <- 20 #number of observations per statistical unit
n_tot <- dim(Obs)[1]
bt <- seq(1, n_tot, by = n)
distr <- c("exp", "gaussian")

#Initialize the HMM
hmm <- set_mhmm(Obs, bT = bt, nStates = 2, distr = distr)
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Multivariate Hidden Markov Models for disease progression, Mox Report 59/2018, 2018
}
\seealso{
\code{\link{fitBM_mhmm}}
}
