% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mhmm}
\alias{summary.mhmm}
\title{Summarizing multivariate Hidden Markov Models}
\usage{
\method{summary}{mhmm}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{mhmm}", a result of a call to \code{fitBM_mhmm}}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
The function "\code{summary.mhmm}" returns a list of summary statistics for a hidden markov model obtained through the Baum-Welch algorithm.
}
\description{
\code{summary} method for class "\code{mhmm}".
}
\examples{
data(copulahmmdata)
Obs <- copulahmmdata
n <- 20 #number of statistical units
n_tot <- 5000 #total number of observations
bt <- seq(1, n_tot, by = n)
distr <- c("exp", "gaussian")
#Initialize the HMM
parameters <- list(as.matrix(c(1,0.25)), matrix(c(3, -1, 1, 1), nrow = 2))
corr <- array(c(1, 0.4, 0.4, 1, 1, 0.1, 0.1, 1), dim = c(2, 2, 2))
hmm <- set_mhmm(Obs, bT = bt, nStates = 2, params = parameters, corr = corr, distr = distr)
# Compute the parameters of the HMM with the Baum-Welch algorithm
bw <- fitBM_mhmm(hmm)

summary(bw)
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Multivariate Hidden Markov Models for disease progression, Mox Report 59/2018, 2018
}
\seealso{
\code{\link{fitBM_mhmm}}
}
