% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs.R
\name{hs}
\alias{hs}
\title{Horseshoe regression Gibbs-sampler}
\usage{
hs(X, y, niter = 1000, hsplus = F, prior = NULL, thin = 1,
  restricted = 0)
}
\arguments{
\item{X}{A matrix containing the predictor variables to be used.}

\item{y}{The vector of numeric responses.}

\item{niter}{Number of posterior samples.}

\item{hsplus}{If "hsplus=T" the horseshoe+ extension will be used.}

\item{prior}{Prior for the individual predictors. If all 1 a standard horseshoe model is fit.}

\item{thin}{If > 1 thinning is performed to reduce autocorrelation.}

\item{restricted}{Threshold for restricted Gibbs sampling. In each iteration only coefficients with scale > restricted are updated. Set restricted = 0 for unrestricted Gibbs sampling.}
}
\value{
A list containing the posterior samples of the following parameters:
\item{beta}{Matrix containing the posterior samples for the regression coefficients.}
 \item{sigma}{Vector contraining the Posterior samples of the error variance.}
 \item{tau}{Vector contraining the Posterior samples of the overall shrinkage.}
\item{lambda}{Matrix containing the posterior samples for the individual shrinkage parameter.}
}
\description{
Generates posterior samples using the horseshoe prior. The Gibbs sampling method from \insertRef{simple}{horserule} is used to generate the posterior samples.
}
\examples{
x = matrix(rnorm(1000), ncol=10)
y = apply(x,1,function(x)sum(x[1:5])+rnorm(1))
hsmod = hs(X=x, y=y, niter=100)
}
