% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{runHowlerExample}
\alias{runHowlerExample}
\alias{availableHowlerExamples}
\title{Run \code{\{howler\}} Example Applications}
\usage{
runHowlerExample(example = "basic", display.mode = "showcase", ...)

availableHowlerExamples()
}
\arguments{
\item{example}{Name of the example to load. Current examples include:
\describe{
\item{basic}{Basic example of \code{howler} in use}
\item{full}{Basic example of using all buttons available in \code{howler}}
\item{module}{Example of using the \code{howlerModule}}
\item{server}{Example showing server-side functionality}
}}

\item{display.mode}{The mode in which to display the application. By default set to \code{"showcase"} to show
code behind the example.}

\item{...}{Optional arguments to send to \code{shiny::runApp}}
}
\value{
This function does not return a value; interrupt R to stop the application (usually by pressing Ctrl+C or Esc).
}
\description{
Run \code{\{howler\}} Example Applications
}
\examples{
availableHowlerExamples()

if (interactive()) {
  library(shiny)
  library(howler)

  runHowlerExample("basic")
}

}
