% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.hpi}
\alias{plot.hpi}
\title{Plot method for `hpi` object}
\usage{
\method{plot}{hpi}(x, ...)
}
\arguments{
\item{x}{Object to plot of class `hpi`}

\item{...}{Additional Arguments}
}
\value{
`plotindex` object inheriting from a ggplot object
}
\description{
Specific plotting method for hpi objects
}
\section{Further Details}{

Additional argument can include those argument for `plot.hpindex``
}

\examples{

 # Load data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Plot data
 plot(rt_index)
 plot(rt_index, smooth = TRUE)

}
