% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graphs.R
\name{hpo.plot}
\alias{hpo.plot}
\title{Plot HPO graph object}
\usage{
hpo.plot(hpo.terms, terms = apply.term.filters(hpo.terms = hpo.terms,
  plotting.context = plotting.context, term.filters = list()),
  plotting.context = NULL, hpo.phenotypes = NULL, term.frequencies = NULL,
  colours = rep("cyan", length(terms)), labels = get.simple.node.labels,
  borders = get.no.borders, sizes = get.standard.sizes,
  font.sizes = rep(30, length(terms)), shapes = rep("circle",
  length(terms)), nodeAttrs = NULL, ...)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{terms}{Character vector of HPO terms}

\item{plotting.context}{List object with hpo.phenotypes slot for list of character vectors of terms}

\item{hpo.phenotypes}{List of HPO term character vectors}

\item{term.frequencies}{Numeric vector of population frequencies of terms (named by term codes)}

\item{colours}{Function to set the colours of the HPO nodes in the graph based on the plotting context, or a character vector of colours}

\item{labels}{Function to set the labels of the HPO nodes in the graph based on the plotting context, or a character vector of node labels}

\item{borders}{Function to set the borders of the HPO nodes in the graph based on the plotting context, or a character vector of border colours}

\item{sizes}{Function to set the sizes of the HPO nodes in the graph based on the plotting context, or a numeric vector of node sizes}

\item{font.sizes}{Function to set the font sizes of the text to be placed in the HPO nodes in the graph based on the plotting context, or an integer vector of font sizes}

\item{shapes}{Function to set the shapes of the HPO nodes in the graph based on the plotting context, or a character vector of shape names (defaults to 'circle')}

\item{nodeAttrs}{Pass nodeAttrs directly to rgraphviz plotting function}

\item{...}{Extra arguments to pass to plot}
}
\value{
Plots graph
}
\description{
Plot HPO graph object
}
\examples{
data(hpo.terms)
hpo.plot(
	hpo.terms=hpo.terms,
	terms=get.ancestors(hpo.terms,
		c("HP:0001382","HP:0004272","HP:0007917","HP:0004912","HP:0001596"))
)
}
\seealso{
\code{\link{get.hpo.graph}}
}

