% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft.R, R/modern.r, R/roboto-condensed.r
\name{theme_ft_rc}
\alias{theme_ft_rc}
\alias{theme_modern_rc}
\alias{theme_ipsum_rc}
\title{A precise & pristine \link{ggplot2} theme with opinionated defaults and an emphasis on typoghraphy}
\usage{
theme_ft_rc(
  base_family = "Roboto Condensed",
  base_size = 11.5,
  plot_title_family = base_family,
  plot_title_size = 18,
  plot_title_face = "bold",
  plot_title_margin = 10,
  subtitle_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  subtitle_size = 13,
  subtitle_face = "plain",
  subtitle_margin = 15,
  strip_text_family = base_family,
  strip_text_size = 12,
  strip_text_face = "plain",
  caption_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  caption_size = 9,
  caption_face = "plain",
  caption_margin = 10,
  axis_text_size = base_size,
  axis_title_family = base_family,
  axis_title_size = 9,
  axis_title_face = "plain",
  axis_title_just = "rt",
  plot_margin = margin(30, 30, 30, 30),
  grid = TRUE,
  axis = FALSE,
  ticks = FALSE
)

theme_modern_rc(
  base_family = "Roboto Condensed",
  base_size = 11.5,
  plot_title_family = base_family,
  plot_title_size = 18,
  plot_title_face = "bold",
  plot_title_margin = 10,
  subtitle_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  subtitle_size = 13,
  subtitle_face = "plain",
  subtitle_margin = 15,
  strip_text_family = base_family,
  strip_text_size = 12,
  strip_text_face = "plain",
  caption_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  caption_size = 9,
  caption_face = "plain",
  caption_margin = 10,
  axis_text_size = base_size,
  axis_title_family = base_family,
  axis_title_size = 9,
  axis_title_face = "plain",
  axis_title_just = "rt",
  plot_margin = margin(30, 30, 30, 30),
  grid = TRUE,
  axis = FALSE,
  ticks = FALSE
)

theme_ipsum_rc(
  base_family = "Roboto Condensed",
  base_size = 11.5,
  plot_title_family = base_family,
  plot_title_size = 18,
  plot_title_face = "bold",
  plot_title_margin = 10,
  subtitle_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  subtitle_size = 13,
  subtitle_face = "plain",
  subtitle_margin = 15,
  strip_text_family = base_family,
  strip_text_size = 12,
  strip_text_face = "plain",
  caption_family = if (.Platform$OS.type == "windows") "Roboto Condensed" else
    "Roboto Condensed Light",
  caption_size = 9,
  caption_face = "plain",
  caption_margin = 10,
  axis_text_size = base_size,
  axis_title_family = base_family,
  axis_title_size = 9,
  axis_title_face = "plain",
  axis_title_just = "rt",
  plot_margin = margin(30, 30, 30, 30),
  panel_spacing = grid::unit(2, "lines"),
  grid_col = "#cccccc",
  grid = TRUE,
  axis_col = "#cccccc",
  axis = FALSE,
  ticks = FALSE
)
}
\arguments{
\item{base_family, base_size}{base font family and size}

\item{plot_title_family, plot_title_face, plot_title_size, plot_title_margin}{plot tilte family, face, size and margin}

\item{subtitle_family, subtitle_face, subtitle_size}{plot subtitle family, face and size}

\item{subtitle_margin}{plot subtitle margin bottom (single numeric value)}

\item{strip_text_family, strip_text_face, strip_text_size}{facet label font family, face and size}

\item{caption_family, caption_face, caption_size, caption_margin}{plot caption family, face, size and margin}

\item{axis_text_size}{font size of axis text}

\item{axis_title_family, axis_title_face, axis_title_size}{axis title font family, face and size}

\item{axis_title_just}{axis title font justificationk one of \verb{[blmcrt]}}

\item{plot_margin}{plot margin (specify with \link[ggplot2:margin]{ggplot2::margin})}

\item{grid}{panel grid (\code{TRUE}, \code{FALSE}, or a combination of \code{X}, \code{x}, \code{Y}, \code{y})}

\item{axis}{add x or y axes? \code{TRUE}, \code{FALSE}, "\code{xy}"}

\item{ticks}{ticks if \code{TRUE} add ticks}

\item{panel_spacing}{panel spacing (use \code{unit()})}

\item{grid_col}{grid color}

\item{axis_col}{axis color}
}
\description{
You should \code{\link[=import_roboto_condensed]{import_roboto_condensed()}} first and also install the fonts on your
system before trying to use this theme.
}
\details{
There is an option \code{hrbrthemes.loadfonts} which -- if set to \code{TRUE} -- will
call \code{extrafont::loadfonts()} to register non-core fonts with R PDF & PostScript
devices. If you are running under Windows, the package calls the same function
to register non-core fonts with the Windows graphics device.
}
\section{Why Roboto Condensed?}{

It's free, has tolerable kerning pairs and multiple weights. It's also different
than Arial Narrow and the fonts most folks use in ggplot2 charts.
}

\examples{
\dontrun{
library(ggplot2)
library(dplyr)

# seminal scatterplot
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  labs(x="Fuel effiiency (mpg)", y="Weight (tons)",
       title="Seminal ggplot2 scatterplot example",
       subtitle="A plot that is only useful for demonstration purposes",
       caption="Brought to you by the letter 'g'") +
  theme_ipsum_rc()

# seminal bar chart

# note: make this font_rc on Windows
update_geom_font_defaults(family=font_rc_light)

count(mpg, class) \%>\%
  ggplot(aes(class, n)) +
  geom_col() +
  geom_text(aes(label=n), nudge_y=3) +
  labs(x="Fuel effiiency (mpg)", y="Weight (tons)",
       title="Seminal ggplot2 bar chart example",
       subtitle="A plot that is only useful for demonstration purposes",
       caption="Brought to you by the letter 'g'") +
  theme_ipsum_rc(grid="Y") +
  theme(axis.text.y=element_blank())
}
}
