% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrq_glasso.R
\name{hrq_glasso}
\alias{hrq_glasso}
\title{Robust group variable selection for quantile and mean regression}
\usage{
hrq_glasso(
  x,
  y,
  group.index,
  tau = 0.5,
  lambda = NULL,
  weights = NULL,
  w.lambda = NULL,
  gamma = 0.2,
  max_iter = 200,
  apprx = "huber",
  lambda.discard = TRUE,
  method = "quantile",
  scalex = TRUE,
  epsilon = 1e-04,
  beta0 = NULL
)
}
\arguments{
\item{x}{Design matrix (in matrix format)}

\item{y}{Response variable}

\item{group.index}{A vector of group index, e.g., (1,1,1,2,2,2,3,3)}

\item{tau}{Percentile}

\item{lambda}{Shrinkage parameter, default is NULL so that the algorithm chooses a sequence.}

\item{weights}{Observation weights, default is NULL}

\item{w.lambda}{Weights for Shrinkage parameter of each group, default is NULL}

\item{gamma}{Huber parameter. An initial value is 0.2, while the algorithm adaptively tunes the value in each iteration.}

\item{max_iter}{Maximum number of iteration}

\item{apprx}{Approximation method. Default is \code{huber}. The other option is \code{tanh} which uses the hypertangent function to approximate the first order derivative of absolute loss.}

\item{lambda.discard}{Default is TRUE, meaning that the solution path stops if the relative deviance changes sufficiently small. It usually happens near the end of solution path. However, the program returns at least 70 models along the solution path.}

\item{method}{Choice for mean or quantile regression. Default is \code{quantile}.}

\item{scalex}{Standardize design matrix. Default is TRUE.}

\item{epsilon}{The epsilon level convergence. Default is 1e-4.}

\item{beta0}{Initial estimates. Default is NULL.}
}
\value{
It returns a sequence of estimated coefficients for quantile regression with group feature selection corresponding to a sequence of lambda. 
The estimated coefficients are in the sparse matrix format. Returned values also include the sequence of lambda, the null deviance, 
values of penalized loss, and unpenalized loss across the sequence of lambda. 
\item{beta}{The estimated coefficients for all lambdas, stored in sparse matrix format, where each column corresponds to a lambda.}
\item{lambda}{The sequence of lambdas.}
\item{null.dev}{The null deviance.}
\item{pen.loss}{The value of penalized loss for each lambda.}
\item{loss}{The value of unpenalized loss for each lambda.}
\item{index.grp}{Group indices that correspond to the estimated coefficient matrix \code{beta}.}
\item{n.grp}{The number of selected groups for each lambda.}
}
\description{
This function conducts group-wise (with known groups) variable selection for quantile and robust mean regression with the group lasso penalty. 
The Huber loss is used for both types of regression model, where the quantile check function is approximated by Huber loss. A full solution path
is generated unless a single value of the shrinkage parameter is specified.
}
\examples{
n<- 100
p<- 10
x0<- matrix(rnorm(n*p),n,p)
X<- cbind(x0, x0^2, x0^3)[,order(rep(1:p,3))]
y<- -2+X[,1]+0.5*X[,2]-X[,3]-0.5*X[,7]+X[,8]-0.2*X[,9]+rt(n,2)
group<- rep(1:p, each=3)
fit<- hrq_glasso(X, y, group)
fit$beta[,8]

}
\references{
Sherwood, B., and Li, S. (2021) An Efficient Approach to Feature Selection and Estimation for Quantile Regression with Grouped Variables. \emph{Working paper}.

Yang, Y., and Zou, H., (2015) A Fast Unified Algorithm for Solving Group-lasso Penalize Learning Problems, \emph{Statistics and Computing}, 25 1129-1141.
\doi{10.1007/s11222-014-9498-5}.
}
