% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rao}
\alias{rao}
\title{System of genetic-map functions}
\usage{
rao(p, x, inverse = F)
}
\arguments{
\item{p}{mixing parameter (see details); \code{0 <= p <= 1}}

\item{x}{vector of recombination rates}

\item{inverse}{logical, if FALSE recombination rate is mapped to Morgan unit,
if TRUE Morgan unit is mapped to recombination rate (default is FALSE)}
}
\value{
vector of genetic positions in Morgan units
}
\description{
Calculation of genetic distances from recombination rates given
  a mixing parameter
}
\details{
Mixing parameter \code{p=0} would match to Morgan, \code{p=0.25} to
  Carter, \code{p=0.5} to Kosambi and \code{p=1} to Haldane map function.
  As an inverse of Rao's system of functions does not exist, NA will be
  produced if \code{inverse = T}. To approximate the inverse call function
  \code{rao.inv(p, x)}.
}
\examples{
  rao(0.25, seq(0, 0.5, 0.01))
}
\references{
Rao, D.C., Morton, N.E., Lindsten, J., Hulten, M. & Yee, S (1977)
  A mapping function for man. Human Heredity 27: 99-104.
  \doi{10.1159/000152856}
}
