% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/txtFrmt.R
\name{txtRound}
\alias{txtRound}
\title{A convenient rounding function}
\usage{
txtRound(x, digits, excl.cols, excl.rows, txt.NA = "", dec = ".")
}
\arguments{
  \item{x}{The data.frame/matrix to be rounded}

  \item{digits}{The number of digits to round each element
  to. If you provide a vector each element for
  corresponding columns.}

  \item{excl.cols}{Rows to exclude from the rounding
  procedure. This can be either a number or regular
  expression.}

  \item{excl.rows}{Columns to exclude from the rounding
  procedure. This can be either a number or regular
  expression.}

  \item{txt.NA}{The string to exchange NA with}

  \item{dec}{The decimal marker. If the text is in
  non-english decimal and string formatted you need to
  change this to the apropriate decimal indicator.}
}
\value{
\code{matrix/data.frame}
}
\description{
A convenient rounding function
}
\examples{
mx <- matrix(c(1, 1.11, 1.25,
               2.50, 2.55, 2.45,
               3.2313, 3, pi),
             ncol = 3, byrow=TRUE)
txtRound(mx, 1)
}
\seealso{
Other text formatters: \code{\link{txtMergeLines}};
\code{\link{txtPval}}
}

