% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/htmlTable_helpers.R
\name{prGetCgroupHeader}
\alias{prGetCgroupHeader}
\title{Retrieve a header row}
\usage{
prGetCgroupHeader(x, cgroup_vec, n.cgroup_vec, cgroup_vec.just, css.cgroup_vec,
  row_no, top_row_style, rnames, rowlabel, pos.rowlabel, cgroup_spacer_cells,
  css.cell)
}
\arguments{
  \item{x}{The matrix/data.frame with the data. For the
  \code{print} and \code{knit_print} it takes a string of
  the class \code{htmlTable} as \code{x} argument.}

  \item{cgroup_vec}{The cgroup may be a matrix, this is
  just one row of that matrix}

  \item{n.cgroup_vec}{The same as above but for the
  counter}

  \item{cgroup_vec.just}{The same as above bot for the
  justificaiton}

  \item{css.cgroup_vec}{The CSS row corresponding to the
  current row}

  \item{row_no}{The row number within the header group.
  Useful for multirow headers when we need to output the
  rowlabel at the \code{pos.rowlabel} level.}

  \item{top_row_style}{The top row has a special style
  depending on the \code{ctable} option in the
  \code{htmlTable} call.}

  \item{rnames}{Default rownames are generated from
  \code{\link[base]{rownames}(x)}. If you provide
  \code{FALSE} then it will skip the rownames. \emph{Note:}
  For \code{data.frames} if you do
  \code{\link[base]{rownames}(my_dataframe) <- NULL} it
  still has rownames. Thus you need to use \code{FALSE} if
  you want to surpress rownames for \code{data.frames}.}

  \item{rowlabel}{If the table has rownames or
  \code{rnames}, rowlabel is a character string containing
  the column heading for the \code{rnames}.}

  \item{pos.rowlabel}{Where the rowlabel should be
  positioned. This value can be \code{"top"},
  \code{"bottom"}, \code{"header"}, or a integer between
  \code{1} and \code{nrow(cgroup) + 1}. The options
  \code{"bottom"} and \code{"header"} are the same, where
  the row label is presented at the same level as the
  header.}

  \item{cgroup_spacer_cells}{The spacer cells due to the
  multiple cgroup levels. With multiple rows in cgroup we
  need to keep track of how many spacer cells occur between
  the columns. This variable contains is of the size
  \code{ncol(x)-1} and 0 if there is no cgroup element
  between.}

  \item{css.cell}{The css.cell element allows you to add
  any possible CSS style to your table cells. If you
  provide a vector the vector it is assummed that the
  styles should be repeated throughout the columns. If you
  provide a matrix of the same size as your \code{x}
  argument. If have \code{ncol(x) + 1} the first row will
  correspond to the rowname style. Correspondingly if the
  size is \code{nrow(x) + 1} it is assummed that the first
  row is the header row.}
}
\value{
\code{string}
}
\description{
This function retrieves a header row, i.e. a row within the
<th> elements on top of the table. Used by
\code{\link{htmlTable}}.
}
\seealso{
Other hidden helper functions for \code{\link{htmlTable}}:
\code{\link{prAddCells}};
\code{\link{prAddSemicolon2StrEnd}};
\code{\link{prGetRowlabelPos}}; \code{\link{prGetStyle}};
\code{\link{prPrepareAlign}};
\code{\link{prPrepareCgroup}}; \code{\link{prTblNo}}
}
\keyword{internal}

