% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyHtmlTable.R
\name{tidyHtmlTable}
\alias{tidyHtmlTable}
\title{Generate an htmlTable using tidy data as input}
\usage{
tidyHtmlTable(
  x,
  value,
  header,
  rnames,
  rgroup,
  hidden_rgroup,
  cgroup,
  tspanner,
  hidden_tspanner,
  skip_removal_warning = getOption("htmlTable.skip_removal_warning", FALSE),
  rnames_unique,
  table_fn = htmlTable,
  ...
)
}
\arguments{
\item{x}{Tidy data used to build the \code{htmlTable}}

\item{value}{The column containing values filling individual cells of the
output \code{htmlTable}. Defaults to "value" as used by \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}.}

\item{header}{The column in \code{x} specifying column headings}

\item{rnames}{The column in \code{x} specifying row names. Defaults to "name" as used by
\code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}.}

\item{rgroup}{The column in \code{x} specifying row groups}

\item{hidden_rgroup}{\code{strings} with \code{rgroup} values that will be hidden  (the values will
still be there but the spanner will be set to "" and thus ignored by \code{\link[=htmlTable]{htmlTable()}}).}

\item{cgroup}{The column or columns in \code{x} specifying the column groups}

\item{tspanner}{The column in \code{x} specifying \code{tspanner} groups}

\item{hidden_tspanner}{\code{strings} with \code{tspanner} values that will be hidden (the values will
still be there but the spanner will be set to "" and thus ignored by \code{\link[=htmlTable]{htmlTable()}}).}

\item{skip_removal_warning}{\code{boolean} suppress warning message when removing NA columns.}

\item{rnames_unique}{Similar to \code{rnames}  where we have issues with the uniqueness of a
row as selected by the select statement. See section below on \emph{Row uniqueness}.}

\item{table_fn}{The table function that should receive the input, defaults to \code{\link[=htmlTable]{htmlTable()}}
but you can provide any function that uses the same input formatting. This package was inspired
by the \code{\link[Hmisc:latex]{Hmisc::latex()}} function.}

\item{...}{Additional arguments that will be passed to the inner
\code{\link[=htmlTable]{htmlTable()}} function}
}
\value{
Returns html code that will build a pretty table
}
\description{
Builds an \code{htmlTable} by mapping columns from the input data, \code{x},
to elements of an output \code{htmlTable} (e.g. \code{rnames}, \code{header}, etc.). This
provides a \pkg{ggplot2}-like interface you can pivot rows/columns as required. The
typical use case is when you are using \code{dplyr} together with the
\code{tidyverse} data processing functions, see \code{vignette("tidyHtmlTable")}.
}
\section{Column-mapping parameters}{


The \code{tidyHtmlTable} function is designed to work like ggplot2 in that
columns from \code{x} are mapped to specific parameters from the
\code{htmlTable} function. At minimum, \code{x} must contain the names
of columns mapping to \code{rnames}, \code{header}, and \code{rnames}.
\code{header} and \code{rnames} retain the same meaning as in the
htmlTable function. \code{value} contains the individual values that will
be used to fill each cell within the output \code{htmlTable}.

A full list of parameters from \code{htmlTable} which may be mapped to
columns within \code{x} include:
\itemize{
\item \code{value}
\item \code{header}
\item \code{rnames}
\item \code{rgroup}
\item \code{cgroup}
\item \code{tspanner}
}

Also note that the coordinates of each \code{value} within \code{x} must be
unambiguously mapped to a position within the output \code{htmlTable}.
Therefore, the each row-wise combination the variables specified above
contained in \code{x} must be unique.
}

\section{Sorting}{


Sorting of rows is as of version 2.0 skipped as we may have situations with
repeating inputs and this can easily be performed pre-function by calling
\code{\link[dplyr:arrange]{dplyr::arrange()}} prior to \code{tidyHtmlTable}.

Columns are sorted by \code{arrange(cgroup, header)} where \code{cgroup} will be
expanded to the columns of the \code{cgroup} argument, e.g. \verb{cgroup = c(a, b), header = c}
will become \code{arrange(a, b, c)}. If you want to sort in non-alphabetic order
you can provide a \code{factor} variable and that information will be retained.
}

\section{Hidden values}{


\code{htmlTable} Allows for some values within \code{rgroup},
\code{cgroup}, etc. to be specified as \code{""}. The following parameters
allow for specific values to be treated as if they were a string of length
zero in the \code{htmlTable} function.
\itemize{
\item \code{hidden_rgroup}
\item \code{hidden_tspanner}
}
}

\section{Simple tibble output}{


The tibble discourages the use of row names. There is therefore a convenience
option for \code{tidyHtmlTable} where you can use the function just as you
would with \code{\link[=htmlTable]{htmlTable()}} where \code{rnames} is populated with
the \code{rnames} argument provided using \code{tidyselect} syntax (defaults to
the "names" column if present int the input data).
}

\section{Additional dependencies}{


In order to run this function you also must have \pkg{dplyr},
\pkg{tidyr}, \pkg{tidyselect} and \pkg{purrr}
packages installed. These have been removed due to
the additional 20 Mb that these dependencies added (issue #47).
\emph{Note:} if you use \pkg{tidyverse} it will already have
all of these and you do not need to worry.
}

\section{Row uniqueness}{


Usually each row should have a unique combination of \code{rnames}, \code{header}, \code{crgroup}, ...
Sometimes though rows come in a distinct order and the order identifies
the row more than the name. If we are identifying bone fractures using the
AO-classification we will have classes ranging in the form of:
\itemize{
\item A
\item A1
\item A1.1
\item A2
\item A2.1
\item A2.2
\item B
\item ...
}

we could therefore like to simplify the names to:
\itemize{
\item A
\item .1
\item ...1
\item .2
\item ...1
\item ...2
\item B
\item ...
}

And still retain the ability to follow what row corresponds to a given class. To
do this you need to provide the original unique name in the parameter \code{rnames_unique}
as tidyHtmlTable otherwise will merge rows not intended for merging.

\emph{Note} it is recommended that you verify with the full names just to make sure that
any unexpected row order change has happened in the underlying pivot functions.
}

\examples{
library(tibble)
library(dplyr)
library(tidyr)

mtcars \%>\%
  rownames_to_column() \%>\%
  select(rowname, cyl, gear, hp, mpg, qsec) \%>\%
  pivot_longer(names_to = "per_metric",
               cols = c(hp, mpg, qsec)) \%>\%
  group_by(cyl, gear, per_metric) \%>\%
  summarise(
    Mean = round(mean(value), 1),
    SD = round(sd(value), 1),
    Min = round(min(value), 1),
    Max = round(max(value), 1)
  ) \%>\%
  pivot_longer(names_to = "summary_stat",
               cols = c(Mean, SD, Min, Max)) \%>\%
  ungroup() \%>\%
  mutate(
    gear = paste(gear, "Gears"),
    cyl = paste(cyl, "Cylinders")
  ) \%>\%
  addHtmlTableStyle(align = "r") \%>\%
  tidyHtmlTable(
    header = gear,
    cgroup = cyl,
    rnames = summary_stat,
    rgroup = per_metric,
    skip_removal_warning = TRUE)
}
\seealso{
\code{\link[=htmlTable]{htmlTable()}}
}
