% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_convert_hydraccess.R
\name{d_convert_hydraccess}
\alias{d_convert_hydraccess}
\title{Convert a full Hydraccess database into a new htsr sqlite database (Windows only)}
\usage{
d_convert_hydraccess(db.sqlite, db.hydraccess)
}
\arguments{
\item{db.sqlite}{Full name of the sqlite data base}

\item{db.hydraccess}{Full name of the hydraccess data base}
}
\value{
A new or a replaced sqlite htsr data base.
}
\description{
Because the Hydraccess application only works into a Windows environment,
this function cannot be applied on other platforms (Mas OS or Linux). Additionally,
the R session must be configured in 32b (see the htsr-package vignette).
}
\details{
If the specified sqlite data base already exists, a confirmation
is requested to overwrite it.

An 32b ODBC Microsoft driver must be configured
in the "administrative tools" and installed for the
hydraccess data base. The correct functioning can be verified
using the sub-function u_test_rodbc(db.hydraccess),
which must be successful.
}
\examples{
\dontrun{

d_import_hydraccess("foo.sqlite","foo.mdb")
}


}
\seealso{
\code{\link{d_inventory}} or \code{\link{ds_inventory}} for displaying
the content of the sqlite data base;
 \code{\link{ds_exp_hts}} for extracting a time-series.
}
\author{
P. Chevallier - Nov 2018-Nov 2020
}
