% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_convert.R
\name{f_convert}
\alias{f_convert}
\title{Convert an hts file in another format (xls, xlsx or csv) and vice-versa}
\usage{
f_convert(file, form_start = "hts", form_end = "xlsx")
}
\arguments{
\item{file}{Hts file}

\item{form_start}{Initial format ("hts" (default) or "xls" or
"xlsx")}

\item{form_end}{Final format ("hts" or "xls" or
"xlsx" (default) or "csv" (separator , & decimal .)
or "csv2" (separator ; and decimal ,)}
}
\value{
A file in the requested format with 4 columns: Date, Value,
Station, Sensor
}
\description{
Converter in formats hts, xls, xlsx and text (csv et csv2)
}
\details{
'form_start' = csv or csv2 is for instance not accepted. It could be converted previously
in xls or xlsx format.
}
\examples{
\dontrun{
f_convert(file,  "xlsx", "hts")
}

}
\author{
P. Chevallier - October 2017 - December 2021
}
