% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_gaps.R
\name{p_gaps}
\alias{p_gaps}
\title{Plot of data inventory}
\usage{
p_gaps(files, title = "Inventory", BW = FALSE, margin = 0.1)
}
\arguments{
\item{files}{List of series to plot}

\item{title}{Plot title, default is "Inventory"}

\item{BW}{Black & white plot TRUE / FALSE (default)}

\item{margin}{Reserved space for label writing - default is 0.1}
}
\value{
A ggplot2 object
}
\description{
This function plot an inventory of the data from one or several station(s)-sensor(s).
It is based on the .gap files provided by the function \code{\link{f_properties}}. It allows
to highlight the gaps in time-series.
}
\details{
The inventories are represented with lines displayed bottom-up in the order of the files list.
They are labeled with the station_sensor ids.

Colors are the default colors of ggplot2. For a black & white plot, precise BW = TRUE

The margin value is a reserved space for writing the label at the end of each line.
Default value is 0.1 of the difference between the minimum and the maximum date. It shall be adjusted
following the length of the labels.
}
\seealso{
\code{\link{f_properties}}.
}
\author{
P. Chevallier - Nov 2017 - Sep 2023
}
