% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_httk_params.R
\name{get_httk_params}
\alias{get_httk_params}
\title{Converts the HTTK-Pop population data table to a table of the parameters
needed by HTTK, for a specific chemical.}
\usage{
get_httk_params(indiv_dt, chemcas = NULL, parameters = NULL, model,
  poormetab, fup.censored.dist = FALSE, fup.meas.cv = 0.4,
  clint.meas.cv = 0.3, fup.pop.cv = 0.1, clint.pop.cv = 0.1,
  fup.lod = 0.01, adjusted.Funbound.plasma = T, regression = T,
  well.stirred.correction = T, restrictive.clearance = T,
  concentration = "plasma", clint.pvalue.threshold = 0.05)
}
\arguments{
\item{indiv_dt}{A data table generated by \code{httkpop_generate()}.}

\item{chemcas}{The CAS number of one of the HTTK chemicals (see
\code{\link[httk]{get_cheminfo}}). Defaults to NULL.}

\item{parameters}{A list of chemical-specific model parameters containing at
least Funbound.plasma, Clint, and Fhep.assay.correction, otherwise defaults
to NULL.}

\item{model}{One of the HTTK models: "1compartment", "3compartmentss",
"3compartment", or "pbtk".}

\item{poormetab}{TRUE (include poor metabolizers) or FALSE (exclude poor
metabolizers)}

\item{fup.censored.dist}{Logical. Whether to draw \code{Funbound.plasma} from a
censored distribution or not.}

\item{fup.meas.cv}{Coefficient of variation of distribution of measured
\code{Funbound.plasma} values.}

\item{clint.meas.cv}{Coefficient of variation of distribution of measured 
\code{Clint} values.}

\item{fup.pop.cv}{Coefficient of variation of distribution of population
\code{Funbound.plasma} values.}

\item{clint.pop.cv}{Coefficient of variation of distribution of population
\code{Clint} values.}

\item{fup.lod}{The average limit of detection for \code{Funbound.plasma}. if
\code{fup.censor == TRUE}, the \code{Funbound.plasma} distribution will be
censored below \code{lod/2}. Default value is 0.01.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{well.stirred.correction}{If TRUE (default) then the well-stirred
correction (Rowland et al., 1973) is used in the calculation of hepatic
clearance for the models that do not include flows for first-pass metabolism
(currently, 1compartment and 3compartmentss). This assumes clearance
relative to amount unbound in whole blood instead of plasma, but converted
for use with plasma concentration.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE (default TRUE).}

\item{concentration}{Blood, plasma, or tissue concentration.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}
}
\value{
A data.table whose columns correspond to the parameters of the HTTK
model specified in \code{model}, and whose rows correspond to the
individuals (rows) of \code{indiv_dt}.
}
\description{
Takes the data table generated by \code{httkpop_generate}, and converts it
to the corresponding table of HTTK model parameters for a specified chemical
and HTTK model.
}
\examples{

set.seed(42)
indiv_examp <- httkpop_generate(method="d", nsamp=100)
httk_param <- get_httk_params(indiv_dt=indiv_examp, 
chemcas="80-05-7", 
model="1compartment", 
poormetab=TRUE, 
fup.censored.dist=TRUE)

}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to
environmental chemicals by simulating toxicokinetic variability."
Environment International 106 (2017): 105-118

Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. "Clearance concepts
in pharmacokinetics." Journal of Pharmacokinetics and Biopharmaceutics 1.2
(1973): 123-136.
}
\author{
Caroline Ring and John Wambaugh
}
