% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/honda.ivive.R
\name{honda.ivive}
\alias{honda.ivive}
\title{Return the assumptions used in Honda et al. 2019}
\usage{
honda.ivive(method = "Honda1", tissue = "liver")
}
\arguments{
\item{method}{This is set to one of "Honda1", "Honda2", "Honda3", or "Honda4".}

\item{tissue}{This is only relevant to "Honda4" and indicates the relevant tissue compartment.}
}
\value{
A list of tissue, bioactive.free.invivo, and restrictive.clearance assumptions.
}
\description{
This function returns four of the better performing sets of assumptions evaluated in Honda et al. 2019 
(https://doi.org/10.1371/journal.pone.0217564).These include four different combinations of hepatic clearance assumption, in vivo bioactivity assumption, 
and relevant tissue assumption. Generally, this function is not called directly by the user, but instead
called by setting the IVIVE option in calc_mc_oral_equiv, calc_mc_css, and calc_analytic functions. Currently, these IVIVE option 
is not implemented the solve_1comp etc. functions.
}
\details{
"Honda1" - tissue = NULL, restrictive.clearance = TRUE, bioactive.free.invivo = TRUE
      This assumption assumes restrictive hepatic clearance, and treats the free concentration in plasma as 
      the bioactive concentration in vivo. This option must be used in combination with the concentration in vitro 
      predicted by armitage_eval(), otherwise the result will be the same as "Honda2". This option corresponds to the result 
      in Figure 8 panel c) restrictive, mean free plasma conc., Armitage in Honda et al. 2019.
"Honda2" - tissue = NULL, restrictive.clearance = TRUE, bioactive.free.invivo = TRUE
      This assumption assumes restrictive hepatic clearance, and treats the free concentration in plasma as 
      the bioactive concentration in vivo. This option corresponds to the result 
      in Figure 8 panel b) restrictive, mean free plasma conc. in Honda et al. 2019.
"Honda3" - tissue = NULL, restrictive.clearance = TRUE, bioactive.free.invivo = TRUE
      This assumption assumes restrictive hepatic clearance, and treats the free concentration in plasma as 
      the bioactive concentration in vivo. This option corresponds to the result 
      in Figure 8 panel a) restrictive, mean total plasma conc. in Honda et al. 2019.
"Honda4" - tissue = tissue, restrictive.clearance = FALSE, bioactive.free.invivo = TRUE
      This assumption assumes restrictive hepatic clearance, and treats the free concentration in plasma as 
      the bioactive concentration in vivo. The input tissue should be relevant to the in vitro assay endpoint used as input or that
      the result is being compared to. This option corresponds to the result 
      in Figure 8 panel d) nonrestrictive, mean tissue conc. in Honda et al. 2019.
}
\examples{
honda.ivive(method = "Honda1", tissue = NULL)

}
\references{
Honda, Gregory S., et al. "Using the Concordance of In Vitro and 
In Vivo Data to Evaluate Extrapolation Assumptions." 2019. PLoS ONE 14(5): e0217564.
}
\author{
Greg Honda and John Wambaugh
}
\keyword{Solve}
