% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_partitioning_schmitt.R
\name{predict_partitioning_schmitt}
\alias{predict_partitioning_schmitt}
\title{Predict partition coefficients using the method from Schmitt (2008).}
\usage{
predict_partitioning_schmitt(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  parameters = NULL,
  alpha = 0.001,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  regression.list = c("brain", "adipose", "gut", "heart", "kidney", "liver", "lung",
    "muscle", "skin", "spleen", "bone"),
  tissues = NULL,
  minimum.Funbound.plasma = 1e-04,
  suppress.messages = FALSE
)
}
\arguments{
\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{parameters}{Chemical parameters from \code{\link{parameterize_schmitt}}
overrides chem.name, dtxsid, and chem.cas.}

\item{alpha}{Ratio of Distribution coefficient D of totally charged species
and that of the neutral form}

\item{adjusted.Funbound.plasma}{Whether or not to use Funbound.plasma
adjustment.}

\item{regression}{Whether or not to use the regressions.  Regressions are
used by default.}

\item{regression.list}{Tissues to use regressions on.}

\item{tissues}{Vector of desired partition coefficients.  Returns all by
default.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
Returns tissue to unbound plasma partition coefficients for each
tissue.
}
\description{
This function implements the method from Schmitt (2008) in predicting the 
tissue to unbound plasma partition coefficients for the tissues contained 
in the tissue.data table.
}
\details{
A separate regression is used when adjusted.Funbound.plasma is FALSE.

A regression is used for membrane affinity when not provided.  The
regressions for correcting each tissue are performed on tissue plasma
partition coefficients (Ktissue2pu * Funbound.plasma) calculated with the
corrected Funbound.plasma value and divided by this value to get Ktissue2pu.
Thus the regressions should be used with the corrected Funbound.plasma.

The red blood cell regression can be used but is not by default because of
the span of the data used, reducing confidence in the regression for higher
and lower predicted values.

Human tissue volumes are used for species other than Rat.
}
\examples{

predict_partitioning_schmitt(chem.name='ibuprofen',regression=FALSE)

}
\references{
Schmitt, Walter. "General approach for the calculation of tissue to plasma 
partition coefficients." Toxicology in Vitro 22.2 (2008): 457-467.

Birnbaum, L., et al. "Physiological parameter values for PBPK models." 
International Life Sciences Institute, Risk Science Institute, Washington, 
DC (1994).

Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of pharmacokinetics 
and pharmacodynamics 44.6 (2017): 549-565.

Yun, Y. E., and A. N. Edginton. "Correlation-based prediction of 
tissue-to-plasma partition coefficients using readily available input 
parameters." Xenobiotica 43.10 (2013): 839-852.
}
\author{
Robert Pearce
}
\keyword{Parameter}
