% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_volume_of_distribution.R
\name{calc_vdist}
\alias{calc_vdist}
\title{Calculate the volume of distribution for a one compartment model.}
\usage{
calc_vdist(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  default.to.human = FALSE,
  species = "Human",
  suppress.messages = FALSE,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be specified
when Funbound.plasma is not given in parameter list.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified when Funbound.plasma is not given in parameter list.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from parameterize_3comp, parameterize_pbtk or
predict_partitioning_schmitt.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with parition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Volume of distribution}{Units of L/ kg BW.}
}
\description{
This function predicts partition coefficients for all tissues, then lumps them
into a single compartment.
}
\details{
The effective volume of distribution is calculated by summing each tissues
volume times it's partition coefficient relative to plasma. Plasma, and the
paritioning into RBCs are also added to get the total volume of distribution
in L/KG BW. Partition coefficients are calculated using Schmitt's (2008)
method.  When species is specified as rabbit, dog, or mouse, the function
uses the appropriate physiological data(volumes and flows) but substitues
human fraction unbound, partition coefficients, and intrinsic hepatic
clearance.
}
\examples{

calc_vdist(chem.cas="80-05-7")
calc_vdist(chem.name="Bisphenol A")
calc_vdist(chem.name="Bisphenol A",species="Rat")

}
\references{
Schmitt W. "General approach for the calculation of tissue to
plasma partition coefficients." Toxicology In Vitro, 22, 457-467 (2008).
Peyret, T., Poulin, P., Krishnan, K., "A unified algorithm for predicting
partition coefficients for PBPK modeling of drugs and environmental
chemicals." Toxicology and Applied Pharmacology, 249, 197-207 (2010).
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{1compartment}
\keyword{Parameter}
