% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_3comp.R
\name{solve_3comp}
\alias{solve_3comp}
\title{Solve_3comp}
\usage{
solve_3comp(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  times = NULL,
  parameters = NULL,
  days = 10,
  tsteps = 4,
  daily.dose = NULL,
  dose = NULL,
  doses.per.day = NULL,
  initial.values = NULL,
  plots = FALSE,
  suppress.messages = FALSE,
  species = "Human",
  iv.dose = FALSE,
  input.units = "mg/kg",
  output.units = NULL,
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  default.to.human = FALSE,
  recalc.blood2plasma = FALSE,
  recalc.clearance = FALSE,
  dosing.matrix = NULL,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  restrictive.clearance = TRUE,
  minimum.Funbound.plasma = 1e-04,
  monitor.vars = NULL,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{times}{Optional time sequence for specified number of days.  The
dosing sequence begins at the beginning of times.}

\item{parameters}{Chemical parameters from parameterize_3comp function,
overrides chem.name and chem.cas.}

\item{days}{Length of the simulation.}

\item{tsteps}{The number time steps per hour.}

\item{daily.dose}{Total daily dose, mg/kg BW.}

\item{dose}{Amount of a single dose, mg/kg BW.}

\item{doses.per.day}{Number of doses per day.}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
output.units.  Defaults are zero.}

\item{plots}{Plots all outputs if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{iv.dose}{Simulates a single i.v. dose if true.}

\item{input.units}{Input units of interest assigned to dosing,
defaults to mg/kg BW}

\item{output.units}{A named vector of output units expected for the model
results. Default, NULL, returns model results in units specified in the
'modelinfo' file. See table below for details.}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical
in the blood to plasma using the input parameters, calculated with
hematocrit, Funbound.plasma, and Krbc2pu.}

\item{recalc.clearance}{Recalculates the the hepatic clearance
(Clmetabolism) with new million.cells.per.gliver parameter.}

\item{dosing.matrix}{Vector of dosing times or a matrix consisting of two
columns or rows named "dose" and "time" containing the time and amount, in
mg/kg BW, of each dose.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{monitor.vars}{Which variables are returned as a function of time. 
Defaults value of NULL provides "Cliver", "Csyscomp", "Atubules", 
"Ametabolized", "AUC"}

\item{...}{Additional arguments passed to the integrator.}
}
\value{
A matrix of class deSolve with a column for time(in days) and each
compartment, the plasma concentration, area under the curve, and a row for
each time point.
}
\description{
This function solves for the amounts or concentrations of a chemical in
different tissues as functions of time based on the dose and dosing
frequency.  It uses a three compartment model with partition coefficients.
}
\details{
Note that the model parameters have units of hours while the model output is
in days.

Default of NULL for doses.per.day solves for a single dose.

The compartments used in this model are the gutlumen, gut, liver, and
rest-of-body, with the plasma equivalent to the liver plasma.

Model Figure 
\if{html}{\figure{3comp.jpg}{options: width="60\%" alt="Figure: Three
Compartment Model Schematic"}} 
\if{latex}{\figure{3comp.pdf}{options: width=12cm alt="Figure: Three Compartment
Model Schematic"}}

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

solve_3comp(chem.name='Bisphenol-A',doses.per.day=2,daily.dose=.5,days=1,tsteps=2)

params <-parameterize_3comp(chem.cas="80-05-7")
solve_3comp(parameters=params)

}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput
toxicokinetics." Journal of statistical software 79.4 (2017): 1.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{3compartment}
\keyword{Solve}
