% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fup_correction.R
\name{calc_fup_correction}
\alias{calc_fup_correction}
\title{Calculate the correction for lipid binding in plasma binding assay}
\usage{
calc_fup_correction(
  fup = NULL,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  Flipid = NULL,
  plasma.pH = 7.4,
  dow74 = NULL,
  species = "Human",
  default.to.human = FALSE,
  force.human.fup = FALSE,
  suppress.messages = FALSE
)
}
\arguments{
\item{fup}{Fraction unbound in plasma, if provided this argument overides
values from argument parameters and \code{\link{chem.physical_and_invitro.data}}}

\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model}

\item{Flipid}{The fractional volume of lipid in plasma (from \code{\link{physiology.data}})}

\item{plasma.pH}{pH of plasma (default 7.4)}

\item{dow74}{The octanol-water distribution ratio (DOW).}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing fraction of unbound plasma with
human values if true.}

\item{force.human.fup}{Returns human fraction of unbound plasma in
calculation for rats if true.
When species is specified as rabbit, dog, or mouse, the human unbound
fraction is substituted.}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
A numeric fraction unpbound in plasma between zero and one
}
\description{
Poulin and Haddad (2012) observed "...that for
a highly lipophilic compound, the calculated 
\ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}} is by
far [less than] the experimental values observed under
in vitro conditions." Pearce et al. (2017) hypothesized that there was additional lipid
binding in vivo that acted as a sink for lipophilic compounds, reducing the
effective \ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}} in vivo. It is 
possible that this is due to the binding of lipophilic compounds on the non
plasma-side of the rapid equilibrium dialysis plates (Waters et al., 2008).
 Pearce et al. (2017) compared predicted and observed 
 tissue partition coefficients
for a range of compounds. They showed that predictions were improved by 
adding additional binding proportional to the distribution coefficient 
\ifelse{html}{\out{D<sub>ow</sub>}}{\eqn{D_{ow}}} 
(\code{\link{calc_dow}})
and the fractional volume of lipid in
plasma (\ifelse{html}{\out{F<sub>lipid</sub>}}{\eqn{F_{lipid}}}). 
We calculate
\ifelse{html}{\out{F<sub>lipid</sub>}}{\eqn{F_{lipid}}} as the     
sum of the physiological plasma neutral lipid fractional volume and 30 percent of 
the plasma neutral phospholipid fractional volume. We use values
from Peyret et al. (2010) for rats and Poulin and Haddad (2012)
for humans. The estimate of 30 percent of the
neutral phospholipid volume as neutral lipid was used for simplictity's sake in
place of our membrane affinity predictor. To account for additional binding to lipid, 
plasma to water partitioning
(\ifelse{html}{\out{K<sub>plasma:water</sub> = 1/f<sub>up</sub>}}{\eqn{K_{plasma:water} = \frac{1}{f_{up}}}})
is increased as such:
\ifelse{html}{\out{K<sup>corrected</sup><sub>plasma:water</sub> = 1/f<sup>corrected</sup><sub>up</sub> = 1/f<sup>in vitro</sup><sub>up</sub> + D<sub>ow</sub>*F<sub>lipid</sub>}}{\deqn{f^{corrected}_{up} = \frac{1}{f^{corrected}_{up}} = \frac{1}{K_{nL}^{pl}*F_{lipid} + \frac{1}{f^{in vitro}_{up}}}}}
}
\details{
Note that octanal:water partitioning above 1:1,000,000 
(\ifelse{html}{\out{LogD<sub>ow</sub> > 6}}{\eqn{LogD_{ow} > 6}})
are truncated at 1:1,000,000 because greater partitioning would
likely take longer than protein binding assay itself.
}
\references{
Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of pharmacokinetics 
and pharmacodynamics 44.6 (2017): 549-565.

Peyret, Thomas, Patrick Poulin, and Kannan Krishnan. "A unified algorithm 
for predicting partition coefficients for PBPK modeling of drugs and 
environmental chemicals." Toxicology and applied pharmacology 249.3 (2010): 
197-207.

Poulin, Patrick, and Sami Haddad. "Advancing prediction of tissue 
distribution and volume of distribution of highly lipophilic compounds from 
a simplified tissue-composition-based model as a mechanistic animal 
alternative method." Journal of pharmaceutical sciences 101.6 (2012): 
2250-2261.
       
Schmitt, Walter. "General approach for the calculation of 
tissue to plasma partition coefficients." Toxicology in Vitro 22.2 (2008): 
457-467.

Waters, Nigel J., et al. "Validation of a rapid equilibrium dialysis 
approach for the measurement of plasma protein binding." Journal of 
pharmaceutical sciences 97.10 (2008): 4586-4595.
}
\seealso{
\code{\link{apply_fup_adjustment}}

\code{\link{calc_dow}}
}
\author{
John Wambaugh
}
\keyword{in-vitro}
