% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpgd.R
\name{hgd_url}
\alias{hgd_url}
\title{httpgd URL.}
\usage{
hgd_url(
  endpoint = "live",
  which = dev.cur(),
  websockets = TRUE,
  width = -1,
  height = -1,
  renderer = NA,
  history = TRUE,
  host = NULL,
  port = NULL,
  explicit = FALSE
)
}
\arguments{
\item{endpoint}{API endpoint. The default, \code{"live"} is the HTML/JS
plot viewer. Can be set to a numeric plot index or plot ID
(see \code{\link[=hgd_id]{hgd_id()}}) to obtain the direct URL to the SVG.}

\item{which}{Which device (ID).}

\item{websockets}{Use websockets.}

\item{width}{Width of the plot. (Only used when \code{endpoint} is \code{"svg"},
or a plot index or ID.)}

\item{height}{Height of the plot. (Only used when \code{endpoint} is \code{"svg"},
or a plot index or ID.)}

\item{renderer}{Renderer.}

\item{history}{Should the plot history sidebar be visible.}

\item{host}{Replaces hostname.}

\item{port}{Replaces port.}

\item{explicit}{Ads \code{hgd={host}:{port}} query parameter. Needed for host
resolution in some editors.}
}
\value{
URL.
}
\description{
Generate URLs to the plot viewer or to plot SVGs.
This function will only work after starting a device with \code{\link[=hgd]{hgd()}}.
}
\examples{
hgd()

plot(1, 1)
hgd_url(0)
hgd_url(hgd_id(), width = 800, height = 600)

dev.off()
}
