% Generated by roxygen2 (4.0.0): do not edit by hand
\name{oauth1.0_token}
\alias{oauth1.0_token}
\title{Generate an oauth1.0 token.}
\usage{
oauth1.0_token(endpoint, app, permission = NULL,
  cache = getOption("httr_oauth_cache"))
}
\arguments{
\item{cache}{A logical value or a string. \code{TRUE} means to cache
using the default cache file \code{.oauth-httr}, \code{FALSE} means
don't cache, and \code{NA} means to guess using some sensible heuristics.
A string mean use the specified path as the cache file.}

\item{endpoint}{An OAuth endpoint, created by \code{\link{oauth_endpoint}}}

\item{app}{An OAuth consumer application, created by
\code{\link{oauth_app}}}

\item{permission}{optional, a string of permissions to ask for.}
}
\value{
A \code{Token1.0} reference class (RC) object.
}
\description{
This is the final object in the OAuth dance - it encapsulates the app,
the endpoint, other parameters and the received credentials.
}
\details{
See \code{\link{Token}} for full details about the token object, and the
caching policies used to store credentials across sessions.
}
\seealso{
Other OAuth: \code{\link{oauth2.0_token}};
  \code{\link{oauth_app}}; \code{\link{oauth_endpoint}}
}

