% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/oauth-endpoint.r
\name{oauth_endpoint}
\alias{oauth_endpoint}
\title{Describe an OAuth endpoint.}
\usage{
oauth_endpoint(request = NULL, authorize, access, ..., base_url = NULL)
}
\arguments{
\item{request}{url used to request initial (unauthenticated) token.
If using OAuth2.0, leave as \code{NULL}.}

\item{authorize}{url to send client to for authorisation}

\item{access}{url used to exchange unauthenticated for authenticated token.}

\item{...}{other additional endpoints.}

\item{base_url}{option url to use as base for \code{request},
\code{authorize} and \code{access} urls.}
}
\description{
See \code{\link{oauth_endpoints}} for a list of popular OAuth endpoints
baked into httr.
}
\examples{
linkedin <- oauth_endpoint("requestToken", "authorize", "accessToken",
  base_url = "https://api.linkedin.com/uas/oauth")
github <- oauth_endpoint(NULL, "authorize", "access_token",
  base_url = "https://github.com/login/oauth")
facebook <- oauth_endpoint(
  authorize = "https://www.facebook.com/dialog/oauth",
  access = "https://graph.facebook.com/oauth/access_token")

oauth_endpoints
}
\seealso{
Other OAuth: \code{\link{oauth1.0_token}};
  \code{\link{oauth2.0_token}}; \code{\link{oauth_app}};
  \code{\link{oauth_service_token}}
}

