% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-delete.r
\name{DELETE}
\alias{DELETE}
\title{Send a DELETE request.}
\usage{
DELETE(url = NULL, config = list(), ..., handle = NULL)
}
\arguments{
\item{url}{the url of the page to retrieve}

\item{config}{Additional configuration settings such as http
authentication (\code{\link{authenticate}}), additional headers
(\code{\link{add_headers}}), cookies (\code{\link{set_cookies}}) etc.
See \code{\link{config}} for full details and list of helpers.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc,
passed on to \code{\link{modify_url}}. Unnamed parameters will be combined
with \code{\link{config}}.}

\item{handle}{The handle to use with this request. If not
supplied, will be retrieved and reused from the \code{\link{handle_pool}}
based on the scheme, hostname and port of the url. By default \pkg{httr}
requests to the same scheme/host/port combo. This substantially reduces
connection time, and ensures that cookies are maintained over multiple
requests to the same host. See \code{\link{handle_pool}} for more
details.}
}
\description{
Send a DELETE request.
}
\section{RFC2616}{


The DELETE method requests that the origin server delete the resource
identified by the Request-URI. This method MAY be overridden by human
intervention (or other means) on the origin server. The client cannot be
guaranteed that the operation has been carried out, even if the status code
returned from the origin server indicates that the action has been
completed successfully. However, the server SHOULD NOT indicate success
unless, at the time the response is given, it intends to delete the
resource or move it to an inaccessible location.

A successful response SHOULD be 200 (OK) if the response includes an entity
describing the status, 202 (Accepted) if the action has not yet been
enacted, or 204 (No Content) if the action has been enacted but the
response does not include an entity.

If the request passes through a cache and the Request-URI identifies one or
more currently cached entities, those entries SHOULD be treated as stale.
Responses to this method are not cacheable.
}
\examples{
DELETE("http://httpbin.org/delete")
POST("http://httpbin.org/delete")
}
\seealso{
Other http methods: \code{\link{BROWSE}},
  \code{\link{GET}}, \code{\link{HEAD}},
  \code{\link{PATCH}}, \code{\link{POST}},
  \code{\link{PUT}}, \code{\link{VERB}}
}

