% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-auth.R
\name{req_auth_basic}
\alias{req_auth_basic}
\title{Authenticate request with HTTP basic authentication}
\usage{
req_auth_basic(req, username, password = NULL)
}
\arguments{
\item{req}{A \link{request}.}

\item{username}{User name.}

\item{password}{Password. You avoid entering the password directly when
calling this function as it will be captured by \code{.Rhistory}. Instead,
leave it unset and the default behaviour will prompt you for it
interactively.}
}
\value{
A modified HTTP \link{request}.
}
\description{
This sets the Authorization header. See details at
\url{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization}.
}
\examples{
req <- request("http://example.com") |> req_auth_basic("hadley", "SECRET")
req
req |> req_dry_run()

# httr2 does its best to redact the Authorization header so that you don't
# accidentally reveal confidential data. Use `redact_headers` to reveal it:
print(req, redact_headers = FALSE)
req |> req_dry_run(redact_headers = FALSE)

# We do this because the authorization header is not encrypted and the
# so password can easily be discovered:
rawToChar(jsonlite::base64_dec("aGFkbGV5OlNFQ1JFVA=="))
}
